package game.gamestorage;

/**
 * This abstract interface specifies all game independent methods - no matter, if Texas Holdem, Omaha...
 * 
 * @author Witthold/Korol
 */
public abstract interface IF_SetGameStorage {

	/**
	 * sets parameters of current challenge - the gamedef
	 * gamedef_id is parameter of Estimation constructor<br>
	 * - needed to estimate opponents by completed competitions<br>
	 * - called after instanciating History and before instanciating Estimation<br>
	 * 
	 * @param limited - limited:1; pot-limit:0; no-limit: -1
	 * @param minBet - only int possible
	 * @param maxBet - only int possible
	 * @param numPlayers - amount of participating players
	 * @param style - cashgame:1; tournament:2; doyle:3;
	 * @param buyin - only int possible
	 * 
	 * @return gamedef_id
	 */
	public int setGetGamedef(int limited, int minBet, int maxBet, int numPlayers, int style, int buyin);


	/**
	 * stores playernames and there cash when starting competion
	 * 
	 * @param players - all participants as String[] playernames
	 * @param cashInit - starting credits of every player
	 */
	public void setStartCompetition(String[] players, int[] cashInit); // called after #PLAYERS message


	/**
	 * stores the ranking of the finished competition
	 * 
	 * @param ranking of all participants
	 */
	public void setEndCompetition(int[] ranking);

}
