package game;

import game.model.Card;

import java.util.ArrayList;
import java.util.Calendar;

import util.DebugOut;

/**
 * Contains information of one round (sequence of actions and revealed board cards)
 * @author Witthold/Korol
 */
public class Round {

	private long timestamp;
	private ArrayList<Action> actions = new ArrayList<Action>();
	private Card[] boardCards = null;
	

	public Round(Card[] boardCards) {
		
		Calendar now = Calendar.getInstance();
		timestamp = now.getTimeInMillis();
		
//		DebugOut.showVerboseGame("timestamp: " + timestamp);

		this.boardCards = boardCards;
	}
	
	public void add(Action action) {
		
		actions.add(action);
	}
	
	public Card[] getBoardCards() {
		
		return boardCards;
	}
	
	public ArrayList<Action> getHistory() {
		
		return actions;
	}
	
	public ArrayList<Action> getHistory(int n) {

		ArrayList<Action> playersActions = new ArrayList<Action>();
		
		for (Action action : actions) {
			
			if(action.getPlayer() == n) {
				
				playersActions.add(action);
			}
		}
		
		return playersActions;
	}

	public int boardCardsLength() {
		
		if (boardCards != null) {
			
			return boardCards.length;
		} else {

			return 0;
		}
	}

	public String boardCardsToString() {

		if( boardCards != null ) { 
			StringBuffer strB = new StringBuffer();

			for (Card card : boardCards) {
				strB.append(card.toString());
				strB.append("_");
			}

			strB.deleteCharAt(strB.length() - 1);

			return strB.toString();
			
		} else {
			
			return "";
		}
	}
	
	public String gameStorageToString() {
	
		StringBuffer strB = new StringBuffer();
	
		for (Action action : actions) {
			strB.append(action.toString());
		}
	
		return strB.toString();
	}

	public String toString() {
		
		return boardCardsToString() + gameStorageToString();
	}

	public int getFolds() {

		int folds = 0;
		
		for (Action action : actions) {
			
			if( action.isFold() ) {
				
				folds++;
			}
		}
		return folds;
	}
	
	public int getChecks() {

		int checks = 0;
		
		for (Action action : actions) {
			
			if( action.isCheck() ) {
				
				checks++;
			}
		}
		return checks;
	}
	
	public int getCalls() {

		int calls = 0;
		
		for (Action action : actions) {
			
			if( action.isCall() ) {	// TODO maybe add "|| action.isCheck"
				
				calls++;
			}
		}
		return calls;
	}
	
	public int getRaises() {

		int raises = 0;
		
		for (Action action : actions) {
			
			if( action.isRaise() ) {
				
				raises++;
			}
		}
		return raises;
	}

	public long getTimestamp() {

		return timestamp;
	}
}
