package game;

import util.DebugOut;

/**
 * A Player who is extended from Player for playing "Doyle's game".</br>
 * The amount of gain/lost over the hands is stored as gain delta, </br>
 * because the cash is reseted each hand to the initial cash.
 * @author Witthold/Korol
 *
 */
public class DoylesPlayer extends Player {

	/** storage of won/lost money if it is doyles game*/
	private int gainDelta = 0;
	
	
	/**
	 * @param name
	 * 			Name of the player
	 * @param money
	 * 			Initial amount of cash
	 */
	public DoylesPlayer(String name, int money) {
		super(name, money);
	}
	
	/**
	 * Adds the given delta to the total amount of gained/lost money during the competition
	 * @param delta
	 * 			The new gain/loss
	 */
	public void applyDelta(int delta) {
		
		this.gainDelta += delta;
	}
	
	/**
	 * @return	The amount of gain/loss during the competition
	 */
	public int getDelta() {
		
		return gainDelta;
	}
	
	/* (non-Javadoc)
	 * @see game.Player#reset()
	 */
	@Override
	public void reset() {
		
		super.reset();
		cashCurrent = cashInit;
	}

	/* (non-Javadoc)
	 * @see game.Player#compareTo(game.Player)
	 */
	@Override
	public int compareTo(Player player) {

		return gainDelta - ((DoylesPlayer)player).getDelta();
	}

	/* (non-Javadoc)
	 * @see game.Player#printPlayerData()
	 */
	@Override
	public void printPlayerData() {
	
		super.printPlayerData();
		DebugOut.showVerbosePlayer("Delta: " + gainDelta);
	}
}
