package extmodule;

import game.Action;

public interface IF_ExtModule_Feed {

	/**
	 * Tries to initialize the module.
	 * 
	 * @param betStructure The limits for each betting round (0 for no limit)
	 * @param blindStructure The blind sizes for the players after the button
	 * @param ante The ante for each player
	 * @param playerNames The player names in the table order. The name at index 0 is the own name
	 * @param cashOfPlayer The initial cash of the players.
	 * 
	 * @return The success of initializing the module (Is the module able to deal with the limits, blinds, antes, amount of players,...)
	 */
	public boolean initModule(int[] betSizes, int[] betStructure, int[] blindStructure, int ante, String playerNames, int[] cashOfPlayer); 
	
	/**
	 * Informs the module about the beginning of a new hand.
	 */
	public void newHand(int button);

	/**
	 * Informs the module about new hole cards of a player.
	 */
	public void newHoleCards(int player, int[] cards);

	/**
	 * Informs the module about a new action.
	 */
	public void newAction(Action action);

	/**
	 * Informs the module about a new round.
	 */
	public void newRound(int round, int[] newCards);

	/**
	 * Informs the module about the showdown of the hand.
	 */
	public void showdown(int player, int gain);
}
