package bot.talk;

import bot.Bot;

/**
 * Abstract class which contains all protocol independent communication stuff.
 * @author Witthold/Korol
 */
public abstract class Talk {

	/** The actual Bot; needed for communication */
	protected Bot bot;
	protected String serverAdress;	// TODO String vs InetAdress
	protected int port;
	
	/**
	 * Builds a Talk object and sets the given fields.
	 * 
	 * @param bot
	 * @param serverAdress
	 * @param port
	 */
	public Talk(Bot bot, String serverAdress, int port) {
		
		this.bot = bot;
		this.serverAdress = serverAdress;
		this.port = port;
	}
	
	/**
	 * Connects to a server (and a room if necessary).
	 */
	public abstract boolean initConnection();

	/**
	 * Triggers the the game loop.
	 */
	public abstract void run();
	
	/** Sends a fold action. */
	public abstract boolean sendFold();

	/** Sends a call action. */
	public abstract boolean sendCall();

	/** Sends a raise action. */
	public abstract boolean sendRaise();

	/**
	 * Sends a raise action. The final in pot is the total YOU want to have
	 * put in the pot after the raise (ie including previous amounts from
	 * raises, calls, and blinds.
	 */
	public abstract boolean sendRaise(int finalInPot);
	
	//public abstract boolean endConnection() // TODO implement endConnection?
}
