package bot.module.th.shc;

import static util.poker.texas.BetInt.*;
import static util.poker.texas.PositionInt.*;
import util.DebugOut;

/**
 * BSS startinghandchart </br>
 * predefined table - defensiv for less than 10 players </br>
 * table from: </br>
 * http://de.pokerstrategy.com/strategy/bss/1535/1
 * 
 * @author Witthold/Korol
 */
public class TableBSS extends StartingHandChart {

	/** table wants the 5 standard position classes 0-4 */
	private static final int numPosition = 5;
	/** table offers 0-1 Calls */
	private static final int numCalls = 2;
	/** table offers 0-1 Raises */
	private static final int numRaises = 2;


	/**
	 * Constructor calls super of StartingHandChart
	 */
	public TableBSS() {
		super(numPosition, numCalls, numRaises);

		/** fill the table with specific data */
		createTable();

		DebugOut.showVerboseShc("TableBSS");
	}


	/**
	 * fills the table array
	 */
	private void createTable() {
		handlePairs();
		handleAces();
		handleFaceCards();
		handleSuitedConnectors();
	}


	/**
	 * fills proposal of pairs into the table array
	 */
	private void handlePairs() {
		for (int r1 = 2; r1 < table.length; r1++) {
			for (int s1 = 0; s1 < table[0].length; s1++) {
				for (int r2 = 2; r2 < table[0][0].length; r2++) {
					for (int s2 = 0; s2 < table[0][0][0].length; s2++) {
						for (int p = 0; p < table[0][0][0][0].length; p++) {
							for (int c = 0; c < table[0][0][0][0][0].length; c++) {
								for (int r = 0; r < table[0][0][0][0][0][0].length; r++) {
									/* conditions */
									if (r1 == r2) { // pair
										if (r1 > 9) { // MID OR HIGH PAIRS: AA,KK,QQ,JJ,TT; 
											table[r1][s1][r2][s2][p][c][r] = RAISE4;
											if (r > 0) { // +1 raise before	
												table[r1][s1][r2][s2][p][c][r] = CALL20;
												if (r1 > 11) { // HIGH PAIRS: AA,KK,QQ
													table[r1][s1][r2][s2][p][c][r] = RAISE3;
												}
												if (r1 > 12 && r > 1) { // AA,KK	// +2 raise before									
													table[r1][s1][r2][s2][p][c][r] = ALLIN;
												}
											}
										} else { // LOW PAIRS: 99-22
											if (c == 0 && r == 0) { // no call, no raise												
												switch (p) {
												case EARLY:
													break;
												case MIDDLE:
													table[r1][s1][r2][s2][p][c][r] = CALL;
													break;
												case LATE:
													table[r1][s1][r2][s2][p][c][r] = RAISE4;
													break;
												case SB:
												case BB:
													table[r1][s1][r2][s2][p][c][r] = CALL;
													break;
												default:
													System.err.println("ERROR.TableBSS.createTable.switch: Wrong value of position: " + p);
												}
											} else { // +1 raise
												if (r > 0) {
													table[r1][s1][r2][s2][p][c][r] = CALL20;
												} else {
													if (p != EARLY) {
														table[r1][s1][r2][s2][p][c][r] = CALL;
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}


	/**
	 * fills proposal of aces into the table array
	 */
	private void handleAces() {
		for (int r1 = 2; r1 < table.length; r1++) {
			for (int s1 = 0; s1 < table[0].length; s1++) {
				for (int r2 = 2; r2 < table[0][0].length; r2++) {
					for (int s2 = 0; s2 < table[0][0][0].length; s2++) {
						for (int p = 0; p < table[0][0][0][0].length; p++) {
							for (int c = 0; c < table[0][0][0][0][0].length; c++) {
								for (int r = 0; r < table[0][0][0][0][0][0].length; r++) {
									/* conditions */
									if (r1 != r2 && (r1 == 14 || r2 == 14)) { // NO PAIR, ONE ACE
										if (r1 == 13 || r2 == 13) { // HIGH ACES: AK 
											table[r1][s1][r2][s2][p][c][r] = RAISE4;
											//											DebugOut.showVerboseShc("HIGH ACES: AK: " + table[r1][s1][r2][s2][sp][c][r] + " @ " + r1+s1+r2+s2+sp+c+r);
											if (r > 0) { // +1 raise before	
												table[r1][s1][r2][s2][p][c][r] = RAISE3;
											}
										} else { // SECOND SMALLER THAN KING
											if (r1 < 13 && r1 > 9 || r2 < 13 && r2 > 9) { // MID ACES: AQ,AJ,AT 												
												switch (p) {
												case EARLY:
													break;
												case MIDDLE:
													if (c == 0 && r == 0) {
														table[r1][s1][r2][s2][p][c][r] = RAISE4;
													}
													break;
												case LATE:
													if (r == 0) {
														table[r1][s1][r2][s2][p][c][r] = RAISE4;
													}
													break;
												case SB:
													if (r == 0) {
														table[r1][s1][r2][s2][p][c][r] = RAISE4;
														if (c != 0) {
															table[r1][s1][r2][s2][p][c][r] = CALL;
														}
													}
													break;
												case BB:
													if (r == 0) {
														table[r1][s1][r2][s2][p][c][r] = RAISE4;
														if (c != 0) {
															table[r1][s1][r2][s2][p][c][r] = CALL;
														}
													}
													break;
												default:
													System.err.println("ERROR.TableBSS.createTable.switch: Wrong value of position: " + p);
												}
											} else { // SECOND SMALLER THAN 10
												if (s1 == s2) { // SUITED
													switch (p) {
													case EARLY:
														break;
													case MIDDLE:
														break;
													case LATE:
													case SB:
													case BB:
														if (r == 0) {
															table[r1][s1][r2][s2][p][c][r] = RAISE4;
															if (c != 0) {
																table[r1][s1][r2][s2][p][c][r] = CALL;
															}
														}
														break;
													default:
														System.err.println("ERROR.TableBSS.createTable.switch: Wrong value of position: " + p);
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}


	/**
	 * fills proposal of facecards into the table array
	 */
	private void handleFaceCards() {
		for (int r1 = 2; r1 < table.length; r1++) {
			for (int s1 = 0; s1 < table[0].length; s1++) {
				for (int r2 = 2; r2 < table[0][0].length; r2++) {
					for (int s2 = 0; s2 < table[0][0][0].length; s2++) {
						for (int p = 0; p < table[0][0][0][0].length; p++) {
							for (int c = 0; c < table[0][0][0][0][0].length; c++) {
								for (int r = 0; r < table[0][0][0][0][0][0].length; r++) {
									/* conditions */
									if (r1 != r2 && r1 < 14 && r1 > 9 && r2 < 14 && r2 > 9) { // NO PAIR, FACECARDS + 10
										if (s1 == s2) { // SUITED											
											switch (p) {
											case EARLY:
												break;
											case MIDDLE:
												if (c != 0 && r == 0) {
													table[r1][s1][r2][s2][p][c][r] = CALL;
												}
												break;
											case LATE:
											case SB:
											case BB:
												if (r == 0) {
													table[r1][s1][r2][s2][p][c][r] = RAISE4;
													if (c != 0) {
														table[r1][s1][r2][s2][p][c][r] = CALL;
													}
												}
												break;
											default:
												System.err.println("ERROR.TableBSS.createTable.switch: Wrong value of position: " + p);
											}
										} else { // UNSUITED	
											switch (p) {
											case EARLY:
												break;
											case MIDDLE:
												break;
											case LATE:
											case SB:
											case BB:
												if (r == 0) {
													if (c == 0) {
														table[r1][s1][r2][s2][p][c][r] = RAISE4;
													} else if (p > LATE) {
														table[r1][s1][r2][s2][p][c][r] = CALL;
													}
												}
												break;
											default:
												System.err.println("ERROR.TableBSS.createTable.switch: Wrong value of position: " + p);
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}


	/**
	 * fills proposal of suited connectors into the table array
	 */
	private void handleSuitedConnectors() {
		for (int r1 = 2; r1 < table.length; r1++) {
			for (int s1 = 0; s1 < table[0].length; s1++) {
				for (int r2 = 2; r2 < table[0][0].length; r2++) {
					for (int s2 = 0; s2 < table[0][0][0].length; s2++) {
						for (int p = 0; p < table[0][0][0][0].length; p++) {
							for (int c = 0; c < table[0][0][0][0][0].length; c++) {
								for (int r = 0; r < table[0][0][0][0][0][0].length; r++) {
									/* conditions */
									if (s1 == s2 && (Math.abs(r1 - r2) == 1) && r1 < 11 && r2 < 11) { // SUITED CONNECTORS										
										switch (p) {
										case EARLY:
											break;
										case MIDDLE:
											if (c != 0 && r == 0) {
												table[r1][s1][r2][s2][p][c][r] = CALL;
											}
											break;
										case LATE:
											if (r == 0) {
												table[r1][s1][r2][s2][p][c][r] = RAISE4;
												if (c != 0) {
													table[r1][s1][r2][s2][p][c][r] = CALL;
												}
											}
											break;
										case SB:
										case BB:
											if (c != 0 && r == 0) {
												table[r1][s1][r2][s2][p][c][r] = CALL;
											}
											break;
										default:
											System.err.println("ERROR.TableBSS.createTable.switch: Wrong value of position: " + p);
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}

}
