package bot.module.th.shc;

import bot.module.IF_GetProposal;
import game.model.Card;

/**
 * Interface of module startingHandChart </br>
 * This module returns a proposal, so it should extend the superInterface IF_GetProposal </br>
 * 
 * @author Witthold/Korol
 */
public interface IF_StartingHandChart extends IF_GetProposal {

	/**
	 * lookInTable and process proposal
	 * 
	 * @param holeCards - bots hand 
	 * @param activePlayers - amount of 
	 * @param smallBlind -
	 * @param bigBlind -
	 * @param position
	 * 			Position of the player in this hand</br>
	 * 			(0: first player behind the button; 1: second player behind the button; ...)
	 * @param calls - how often was called in this round
	 * @param raises - how often was raised in this round
	 * @return action - may be: </br>
	 *         -1 (flop) </br>
	 *         0 (check/call) </br>
	 *         x (some value, depending on blinds and amountOfActiveOpponent</br>
	 *         	(3*BB + (amountOfActiveOpponent*BB) or 4*BB + (amountOfActiveOpponent*BB))) </br>
	 */
	public int[] getProposal(Card[] holeCards, int activePlayers, int smallBlind, int bigBlind, int position, int calls, int raises);

}
