package bot.module.th.estimation;

import game.gamestorage.texas.db.estimation.GetterDBProjector;

/**
 * This interface specifies the methods needed to estimate at a specific round.</br>
 * Every round has got different criterias for estimation,</br>
 * but all have need of these methods
 * 
 * @author Witthold/Korol
 */
public interface IF_EstimationAtRound {
	
	/**
	 * init estimation at specific round
	 * 
	 * @param gDBP - instance of GetterDBProjector - one instance per player and competition
	 * @param playerId - already generated by db
	 * @param competitionId - already generated by db
	 * @param lastEvaledHandId - already generated by db
	 */
	public void fetchData(GetterDBProjector gDBP);


	/**
	 * estimate opponent at specific round
	 */
	public void estimate();


	/**
	 * merge new analysed data of round into already analysed of this round
	 */
	public void mergeIntoRound();


	/**
	 * merge estimation of round into overall estimation
	 */
	public void mergeIntoOverall(Opponent o);

}
