package bot.module.th.estimation;

import java.util.Map;

import bot.module.IF_GetEstimation;



/**
 * Interface of module estimation </br>
 * It is able to:</br>
 * - get historical information of the player</br>
 * - get current information of the player</br>
 * - estimates the opponent by a particular style</br>
 * - offers the estimation via a Map </br>
 * This module is one of many possible implementations of how to estimate an opponent.</br>
 * All estimating modules should extend the superInterface IF_GetEstimation </br>
 * 
 * @author Witthold/Korol
 */
public interface IF_Estimation extends IF_GetEstimation{	
	
	/**	 
	 * process all completed competitions right now<br>
	 * since the participation players are unknown right now<br>
	 * estimate all players played this gamedef
	 * 
	 * @param gamedef_id - already generated by db -
	 */
	public void estimateCompletedCompetitions(int gamedef_id);


	/**
	 * set currently running competition<br>
	 * cleanup opponentsEstimations by not participating estimated players
	 * 
	 * @return competition is new
	 */
	public boolean initNewCompetition();


	/**
	 * estimate opponent over all rounds</br>
	 * TODO booleans to IF_EstimationAtRound 
	 * 
	 * @return true, if no errors occured
	 */
	public boolean estimate();


	/**
	 * @return Map opponentsEstimations holding all estimations by opponent and competition</br>
	 * Maps format:<br>
	 * playerId, Map oppPerCompetition: competitionId, estimation
	 */
	public Map<Integer, Map<Integer, Opponent>> getOpponentsEstimations();

}
