package bot.module.equity;

import game.model.Card;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class OutsAndOdds {
	// Varibale fuer Singelton
    private static OutsAndOdds instance = null;
			
	private boolean _handPair;
	private boolean _handSuited;
	private boolean _hasPair;
	private int _leftToFlush;
	private int _leftToStraight;
	
	public OutsAndOdds() {
	}
	
	// Singelton getInstance
    public static OutsAndOdds getInstance() {
        if (instance == null) {
            instance = new OutsAndOdds();
    }
        return instance;
    }
	
	public double getOdds(int currentRound, Card[] holeCards, Card[] boardCards) {
		double odds = 0.0;
				
		_handPair = isPair(holeCards);
		_handSuited = isSuited(holeCards);
		_hasPair = checkHandAndBoardForPair(holeCards, boardCards);
		_leftToFlush = checkFlush(holeCards, boardCards);
		_leftToStraight = checkStraight(holeCards, boardCards);
		
		odds = calculateOdds(currentRound, boardCards);
		
		return odds;
	}

	private double calculateOdds(int currentRound, Card[] boardCards) {
		double odd = 0.0;
		int outs = 0;
		
		// Auf Paar
		if (!_hasPair && !_handPair) {
			outs = 6;
		}
		
		// Auf zwei Paare
		// Hat ein Handpaar -> F?r jede Karte die auf dem Board liegt gibt es noch 3 Unbekannte die zu 2 Paare fehlen
		if (_handPair) {
			outs = 3 * boardCards.length;
		}
		
		// Auf zwei Paare
		if (_hasPair) {
			outs = 3;
		}
		
		// Drilling wenn auf Hand Paar + 2 paare
		if (_handPair) {
			outs += 2;
		}
		
		// Drilling wenn Paar + 2 paare
		if (_hasPair) {
			outs = 7;
		}
		
		// Stra?e
		if (_leftToStraight == 1) {
			outs = 3;
		}
		
		// Flush
		if (_leftToFlush == 1) {
			outs = 9;
		}
		
		// Leicht modifiziert von Jenny/Tina
		// Im Turn sollte der Odd = (Outs*2)+2 sein
		// Ausserdem das * 0.01 entfernt
		
		if (currentRound == 1) {
			odd = (outs * 4);
		}
		
		if (currentRound == 2) {
			odd = (outs * 2) + 2;
		}
		
		return odd;
	}

	private int checkStraight(Card[] holeCards, Card[] boardCards) {
		int leftToStraight=0;
		Set<Integer> ranks = new HashSet<Integer>();
		
		for(Card h : holeCards) {
			ranks.add(h.getRank());
		}
		for(Card b : boardCards) {
			ranks.add(b.getRank());
		}
		List<Integer> cardRanks = new ArrayList<Integer>(ranks);
		
		Collections.sort(cardRanks);
		for(Integer card : cardRanks) {
			int count = 1;
			for(int i=1; i<5; i++) {
				if(ranks.contains(card+i))
					count++;
			}
			leftToStraight = (count>leftToStraight) ? count : leftToStraight;
		}
		
		return (5-leftToStraight);
	}

	private int checkFlush(Card[] holeCards, Card[] boardCards) {
		int toFlushLeft = 5;
		
		int suit1 = holeCards[0].getSuitAsInt();
		int suit2 = holeCards[1].getSuitAsInt();
		
		int hFlush = 5;
		int dFlush = 5;
		int sFlush = 5;
		int cFlush = 5;
		
		if (suit1 == 0) {
			dFlush--;		
		} else if (suit1 == 1) {
			hFlush--;
		} else if (suit1 == 2) {
			sFlush--;
		} else if (suit1 == 3) {
			cFlush--;
		}
			
		if (suit2 == 0) {
			dFlush--;		
		} else if (suit2 == 1) {
			hFlush--;
		} else if (suit2 == 2) {
			sFlush--;
		} else if (suit2 == 3) {
			cFlush--;
		}
		
		if (hFlush == 5) {
			hFlush = -1;
		}
		
		if (dFlush == 5) {
			dFlush = -1;		
		}
		
		if (sFlush == 5) {
			sFlush = -1;
		}
		
		if (cFlush == 5) {
			cFlush = -1;
		}
		
		for (Card b : boardCards) {
			if (b.getSuitAsInt() == 0 && dFlush != -1) {
				dFlush--;		
			} else if (b.getSuitAsInt() == 1 && hFlush != -1) {
				hFlush--;
			} else if (b.getSuitAsInt() == 2 && sFlush != -1) {
				sFlush--;
			} else if (b.getSuitAsInt() == 3 && cFlush != -1) {
				cFlush--;
			}
		}
		
		if (dFlush != -1 && dFlush < toFlushLeft) {
			toFlushLeft = dFlush;
		}
		
		if (hFlush != -1 && hFlush < toFlushLeft) {
			toFlushLeft = hFlush;
		}
		
		if (sFlush != -1 && sFlush < toFlushLeft) {
			toFlushLeft = sFlush;
		}
		
		if (cFlush != -1 && cFlush < toFlushLeft) {
			toFlushLeft = cFlush;
		}
		
		return toFlushLeft;
	}

//	private Card[] buildBoard(int currentRound, Card[] boardCards) {
//		int boardSize = 0;
////		Card[] board = null;
//		
//		if (currentRound == 1) {
//			boardSize = 3;
//		} else if (currentRound == 2) {
//			boardSize = 4;
//		} else if (currentRound == 3) {
//			boardSize = 5;
//		}
//		
////		if (boardSize != 0) {
////			board = new Card[boardSize];
////		} else {
////			return null;
////		}
////		
////		for (int i = 0; i < board.length; i++) {
////			if (i < 3) {
////				board[i] = _state.getRound(1).getBoardCards()[i];
////				//TODO
////			} else if(i == 3){
////				board[i] = _state.getRound(2).getBoardCards()[0];
////				//TODO
////			} else if(i == 4) {
////				board[i] = _state.getRound(3).getBoardCards()[0];
////			}
////		}
//		
//		String a = "";
//		
//		for (Card c : boardCards) {
//			a = a + "" + c;
//		}
//		
//		return boardCards;
//	}

	private boolean checkHandAndBoardForPair(Card[] holeCards, Card[] boardCards) {
		for (Card h : holeCards) {
			for (Card b : boardCards) {
				if (h.getRank() == b.getRank()) {
					return true;
				}
			}
		}
		
		return false;
	}

	private boolean isPair(Card[] holeCards) {
		if(holeCards[0].getRank() == holeCards[1].getRank()) {
			return true;
		}		
		return false;
	}

	private boolean isSuited(Card[] holeCards) {
		if(holeCards[0].getSuitAsInt() == holeCards[1].getSuitAsInt()) {
			return true;
		}
		return false;
	}
	
	
}