package bot;

import util.DebugOut;

/**
 * Simple bot who plays all games and bets randomly. 
 * @author Witthold/Korol
 */
public class RandomBot extends Bot {	

    public RandomBot(String config){
      super(config);
    }

    public static void main(String[] args) throws Exception {
		String config = "default.config";
		try {
			if (args != null) {
				if (args.length > 0) {
					DebugOut.showVerboseMain(args[0]);
					config = args[0] + ".config";
				}
			}
		} finally {
			Bot bot = new RandomBot(config);
			bot.run();
		}
	}

	@Override
	protected boolean isPlayable() {

		return true;
	}
	
	@Override
	public int[] getBet() {

		return getRandomBet();
	}
}
