package bot;

import game.Action;
import game.Player;
import game.model.Card;

import java.util.Random;

import util.DebugOut;
import util.poker.texas.BetInt;
import bot.module.equity.OutsAndOdds;

/**
 * Nr5 Bot
 *
 */
public class Nr5 extends Bot {	
	
	int halfPotSize = 0;
	double einsatzWert = 0.0;
	public Card [] meineHoleCards = new Card[2];
	public Card [] gemeinschaftskarten = new Card[5];
	public Card [] meineKartenGesamt =  new Card[7];
	int countGames = 0;
	int countDoubleRounds = 0;
	
	/* 
	 * zur Bestimmung des Setzverhaltens
	 * 0 eigener Bot, 1 links von Bot, 2 rechts vom Bot
	 */
	int[] preFlopFolds = new int[3]; 	
	String[] playerSetType = new String[3];
	
	/*
	 * zur Bestimmung des Bietverhaltens
	 * 0 eigener Bot, 1 links von Bot, 2 rechts vom Bot
	 * 0: fold, 1: check, 2: call, 3: raise/bieten
	 */
	int[][] betBehavier = new int[3][4];
	String[] playerBetType = new String[3];

    public Nr5(String config){
      super(config);
    }

    public static void main(String[] args) throws Exception {
		String config = "default.config";
	
		try {
			if (args != null) {
				if (args.length > 0) {
					DebugOut.showVerboseMain(args[0]);
					config = args[0] + ".config";
				}
			}
		} finally {
			Bot bot = new Nr5(config);
			bot.run();
		}
	}

	@Override
	protected boolean isPlayable() {
		return true;
	}
	
	@Override
	public int[] getBet() {
		
		countDoubleRounds = 0;

		System.out.println("-------------- Nr5 lebt! ----------------");
	
		/* Action[0]:
		 * -1 = FOLD
		 *  1 = CALL
		 *  5 = RAISE
		 */
		int[] action = new int[2];
		int[] leftAction = new int[2];
		int[] rightAction = new int[2];
	
		// Welche Runde sind wir ?
		int currentRound = state.getCurrentRound();
		
		int countChecks = state.getRound().getChecks();
		System.out.println("--- CountChecks: " + countChecks);
		int countCalls = state.getRound().getCalls();
		System.out.println("--- CountCalls: " + countCalls);
		int countRaises = state.getRound().getRaises();
		System.out.println("--- CountRaises: " + countRaises);
		int countFolds = state.getRound().getFolds();
		System.out.println("--- CountFolds: " + countFolds);
		
		Player self = state.getPlayers()[0];
		
		
		// Welche Position haben wir ?
		int currentPosition = self.getCurrentPosition();
		System.out.println("--- CurrentPosition: " + currentPosition);
		
		// Anzahl der Spieler ermitteln
		int countActivePlayer = state.getActivePlayers().length;
		System.out.println("--- CountActivePlayer: " + countActivePlayer);
		
		// Wieviel ist im Pott ?
		int value_pot = state.getPotSize();
		System.out.println("--- PotSize: " + value_pot);
		
		// Runde 0 ist der PreFlop
		if (currentRound == 0) {
			System.out.println("--- Runde 0 - PreFlop Strategie");
			
			System.out.println("--- preflopfold[1] : " + preFlopFolds[1]);
			System.out.println("--- preflopfold[2] : " + preFlopFolds[2]);
			
			// Anzahl der doubleRunden erhhen
			countDoubleRounds++;
			System.out.println("--- countDoubleRounds: " + countDoubleRounds);
			
			// Anzahl der Spiele erhhen
			if (countDoubleRounds == 1){
				countGames++;
				System.out.println("--- countGames: " + countGames);
			}
									
			System.out.println("--- Runde 0 - PreFlop Strategie");			
			
			// Ist der linke Spieler Tight oder Loose Player
			double prozentPreFolds = ((double)preFlopFolds[1] / (double)countGames)*100;
			if (prozentPreFolds > 20){
				playerSetType[1] = "Tight";
			}else{
				playerSetType[1] = "Loose";
			}
			System.out.println("--- Setzverhalten LeftPlayer: " + playerSetType[1]);
			
			// Analysieren des Bietverhaltens des linken Spielers
			// wenn man mehr raised als zu callen oder zu checken dann aggressive
			// wenn man mehr called oder checked als zu raisen oder zu bieten dann passive
			if (betBehavier[1][3] > (betBehavier[1][1] + betBehavier[1][2])){
				playerBetType[1] = "aggresive";
			}else{
				playerBetType[1] = "passive";
			}
			System.out.println("--- Bietverhalten LeftPlayer: " + playerBetType[1]);

			
			// nur ausgeben, wenn Player activ
			Boolean leftPlayerActive = state.getPlayers()[1].isActive();
			System.out.println("--- leftPlayerActive: " + leftPlayerActive);
			if (leftPlayerActive = true){
				// Name des linken Players
				String leftPlayerName = state.getPlayers()[1].getName();
				System.out.println("--- LeftPlayerName: "+ leftPlayerName);
				
				// Was hat Spieler Links von uns gemacht ?
				for (Action a : state.getRound().getHistory(1)) {
					leftAction[0] = a.toInt();	
					// schreibe zur Analyse die Aktion in ein Array
					if (leftAction[0] == -1) {
						betBehavier[1][0]++;
					}else{
						if(leftAction[0] == 0){
							betBehavier[1][1]++;
						}else{
							if(leftAction[0] == 1){
								betBehavier[1][2]++;
							}else{
								if(leftAction[0] == 5){
									betBehavier[1][3]++;
								}
							}
						}
					}
				}
				System.out.println("--- leftAction: " + leftAction[0]);
			}
			// wenn der leftPlayer FOLDet, dann die Anzahl der Folds anzeigen
			if (state.getPlayers()[1].isFolded() == true) {
				System.out.println("--- leftPlayer raus?: " + state.getPlayers()[1].isFolded());
				preFlopFolds[1]++;
				betBehavier[1][0]++;
				System.out.println("--- leftPlayer Fold: " + preFlopFolds[1]);
			}
			
			
			// Ist der rechte Spieler Tight oder Loose Player
			prozentPreFolds = ((double)preFlopFolds[2] / (double)countGames)*100;
			if (prozentPreFolds > 20){
				playerSetType[2] = "Tight";
			}else{
				playerSetType[2] = "Loose";
			}
			System.out.println("--- Setzverhalten RightPlayer: " + playerSetType[2]);
			
			
			// Analysieren des Bietverhaltens des rechten Spielers
			// wenn man mehr raised als zu callen oder zu checken dann aggressive
			// wenn man mehr called oder checked als zu raisen oder zu bieten dann passive
			if (betBehavier[2][3] > (betBehavier[2][1] + betBehavier[2][2])){
				playerBetType[2] = "aggresive";
			}else{
				playerBetType[2] = "passive";
			}
			System.out.println("--- Bietverhalten RightPlayer: " + playerBetType[2]);
			
			// nur ausgeben, wenn Player activ
			Boolean rightPlayerActive = state.getPlayers()[2].isActive();
			System.out.println("--- rightPlayerActive: " + rightPlayerActive);
			if (rightPlayerActive = true){
				// Name des rechten Players
				String rightPlayerName = state.getPlayers()[2].getName();
				System.out.println("--- RightPlayerName: "+ rightPlayerName);
				
				// Was hat Spieler Rechts von uns gemacht ?
				for (Action a : state.getRound().getHistory(2)) {
					rightAction[0] = a.toInt();				
				}
				// schreibe zur Analyse die Aktion in ein Array
				if (rightAction[0] == -1) {
					betBehavier[2][0]++;
				}else{
					if(rightAction[0] == 0){
						betBehavier[2][1]++;
					}else{
						if(rightAction[0] == 1){
							betBehavier[2][2]++;
						}else{
							if(rightAction[0] == 5){
								betBehavier[2][3]++;
							}
						}
					}
				}
			}
		
		// wenn der leftPlayer FOLDet, dann die Anzahl der Folds anzeigen
		if (state.getPlayers()[2].isFolded() == true) {
			System.out.println("--- rightPlayer raus?: " + state.getPlayers()[2].isFolded());
			preFlopFolds[2]++;
			betBehavier[2][0]++;
			System.out.println("--- rightPlayer Fold: " + preFlopFolds[2]);
		}
			
			// Wir checken was wir fr Karten auf der Hand (hole) haben		
			Card[] holeCards = self.getHoleCards();		
			
			int firstHoleCardRank = holeCards[0].getRank();
			int secondHoleCardRank = holeCards[1].getRank();
			
			System.out.println("--- firstHoleCardRank: " + firstHoleCardRank);
			System.out.println("--- secondHoleCardRank: " + secondHoleCardRank);
			
			// Wir spielen nur Kategorie 1 (tight, aggressive) und Kategorie 2 (tight, aggressive)
			// Kategorie 1
			// AA = Raise
			if(firstHoleCardRank == 14 && secondHoleCardRank == 14) {
				action[0] = 5;
			}
			// KK = Raise
			else if(firstHoleCardRank == 13 && secondHoleCardRank == 13) {
				action[0] = 5;
			}
			// QQ = Raise
			else if(firstHoleCardRank == 12 && secondHoleCardRank == 12) {
				action[0] = 5;
			}
			// AKs = Raise TODO
			else if((firstHoleCardRank == 14 && secondHoleCardRank == 13) || (firstHoleCardRank == 13 && secondHoleCardRank == 14)) {
				action[0] = 5;
			}
			// Kategorie 2
			// AQs = Raise TODO
			else if((firstHoleCardRank == 14 && secondHoleCardRank == 12) || (firstHoleCardRank == 12 && secondHoleCardRank == 14)) {
				action[0] = 5;
			}
			// JJ = Raise
			else if(firstHoleCardRank == 11 && secondHoleCardRank == 11) {
				action[0] = 5;
			}
			// TT = Raise
			else if(firstHoleCardRank == 10 && secondHoleCardRank == 10) {
				action[0] = 5;
			}
			// AK = Raise
			else if((firstHoleCardRank == 14 && secondHoleCardRank == 13) || (firstHoleCardRank == 13 && secondHoleCardRank == 14)) {
				action[0] = 5;
			}
			else {
				action[0] = -1;
			}
		}
		// Runde 1 ist der Flop
		else if (currentRound == 1) {
			System.out.println("--- Runde 1 - Flop Strategie");
			
			// Wieviel wurde zuletzt gecalled ?
			int value_highestbet = state.getHighestBet();
			System.out.println("--- HighestBet: " + value_highestbet);	
			
			// Wieviel wird gecalled ?
			int value_callsize = value_highestbet - state.getPlayers()[0].getCurrentBet();
			System.out.println("--- CallSize: " + value_callsize);
			
			// Analysieren des Bietverhaltens des linken Spielers
			// wenn man mehr raised als zu callen oder zu checken dann aggressive
			// wenn man mehr called oder checked als zu raisen oder zu bieten dann passive
			if (betBehavier[1][3] > (betBehavier[1][1] + betBehavier[1][2])){
				playerBetType[1] = "aggresive";
			}else{
				playerBetType[1] = "passive";
			}
			System.out.println("--- Bietverhalten LeftPlayer: " + playerBetType[1]);
						
			Boolean leftPlayerActive = state.getPlayers()[1].isActive();
			System.out.println("--- leftPlayerActive: " + leftPlayerActive);
			if (leftPlayerActive == true){
				// Name des linken Players
				String leftPlayerName = state.getPlayers()[1].getName();
				System.out.println("--- LeftPlayerName: "+ leftPlayerName);
				
				// Was hat Spieler Links von uns gemacht ?
				for (Action a : state.getRound().getHistory(1)) {
					leftAction[0] = a.toInt();	
					// schreibe zur Analyse die Aktion in ein Array
					if (leftAction[0] == -1) {  //FOLD
						betBehavier[1][0]++;
					}else{
						if(leftAction[0] == 0){   //CHECK
							betBehavier[1][1]++;
						}else{
							if(leftAction[0] == 1){  //CALL
								betBehavier[1][2]++;
							}else{
								if(leftAction[0] == 5){  //RAISE
									betBehavier[1][3]++;
								}
							}
						}
					}
				}
				System.out.println("--- leftAction: " + leftAction[0]);
				
				// Falls wir keine Info haben was in dieser Runde passiert ist, dann holen wir uns die Info aus der Vorrunde
				if (leftAction[0] == -11) {
					for (Action a : state.getRound(currentRound - 1).getHistory(1)) {
						leftAction[0] = a.toInt();				
					}
					System.out.println("--- leftAction(lastRound): " + leftAction[0]);
				}
			}
			
			// Analysieren des Bietverhaltens des rechten Spielers
			// wenn man mehr raised als zu callen oder zu checken dann aggressive
			// wenn man mehr called oder checked als zu raisen oder zu bieten dann passive
			if (betBehavier[2][3] > (betBehavier[2][1] + betBehavier[2][2])){
				playerBetType[2] = "aggresive";
			}else{
				playerBetType[2] = "passive";
			}
			System.out.println("--- Bietverhalten RightPlayer: " + playerBetType[2]);
			
			// nur wenn der Spieler aktiv ist
			Boolean rightPlayerActive = state.getPlayers()[2].isActive();
			System.out.println("--- rightPlayerActive: " + rightPlayerActive);
			if (rightPlayerActive == true){
				// Name des rechten Players
				String rightPlayerName = state.getPlayers()[2].getName();
				System.out.println("--- RightPlayerName: "+ rightPlayerName);
				
				// Was hat Spieler Rechts von uns gemacht ?
				for (Action a : state.getRound().getHistory(2)) {
					rightAction[0] = a.toInt();		
					
					// schreibe zur Analyse die Aktion in ein Array
					if (rightAction[0] == -1) {  //FOLD
						betBehavier[2][0]++;
					}else{
						if(rightAction[0] == 0){  // CHECK
							betBehavier[2][1]++;
						}else{
							if(rightAction[0] == 1){  //CALL
								betBehavier[2][2]++;
							}else{
								if(rightAction[0] == 5){  //RAISE
									betBehavier[2][3]++;
								}
							}
						}
					}
				}
				System.out.println("--- rightAction: " + rightAction[0]);
				
				// Falls wir keine Info haben was in dieser Runde passiert ist, dann holen wir uns die Info aus der Vorrunde
//				if (rightAction[0] == -11) {
//					for (Action a : state.getRound(currentRound - 1).getHistory(2)) {
//						rightAction[0] = a.toInt();				
//					}
//					System.out.println("--- rightAction(lastRound): " + rightAction[0]);
//				}
			}
			
			OutsAndOdds oo = new OutsAndOdds();
			double value_odds = oo.getOdds(state.getCurrentRound(), state.getActivePlayers()[0].getHoleCards(), state.getBoardCards());
			System.out.println("--- Odd: " + value_odds + "%");
			
			// Wir checken mal unsere potOdds (Verhltnis zwischen Einsatz / Pot + Einsatz)
			double value_potOdd = ((double)value_callsize / ((double)value_pot + (double)value_callsize)) * 100;
			System.out.println("--- potOdd: " + value_potOdd + "%");
			
			// Strategie bei Flop
			if (value_odds > value_potOdd) {
				// callen oder checken, also mitgehen
				if (value_callsize == 0) {
					// bieten, es hat noch niemand was gesetzt
				}
				else if (value_callsize > 0) {
					// raisen es wurde was gesetzt
					action[0] = BetInt.RAISE;
					// wieviele aktive Spieler
					int aktiveSpiele = state.getActivePlayers().length;
					//aktuellesGebot + erhhung;
					// Continuationbet
					if (aktiveSpiele < 4) {
						//potsize = value_pot
						//hlfte von potsize
						einsatzWert = value_pot / 2;
					}
					// Handschtzen
					else {
						// ein wert zwischen 3/4 und 1 von der potsize
						einsatzWert = (value_pot / 4) * 3;
						
						Random random = new Random();
						int randomWert = random.nextInt(3);
						
						switch (randomWert) {
						case 0: 
							einsatzWert = einsatzWert + 1;
							break;
						case 1: 
							einsatzWert = einsatzWert - 1;
							break;
						case 2: 
							einsatzWert = einsatzWert + 2;
							break;
						case 3: 
							einsatzWert = einsatzWert - 2;
							break;
						default:
						
						}// switch
					} // else
					
					
					// wenn einer der Spieler ein Tight passive Spieler ist, dann bluffen (hoch setzen)
					if (((playerBetType[1].equals("Tight")) && (playerSetType[1].equals("passive"))) || ((playerBetType[2].equals("Tight")) && (playerSetType[2].equals("passive")))){
						einsatzWert = (value_pot / 4) * 3;
					}
					
					action[1] = state.getHighestBet() + (int)einsatzWert;
					System.out.println("--- Die Callsize ist groesser als 0 und wir sind weniger als 4 aktive Mitspieler");
					System.out.println("--- Die Groesse des Pots ist: " + value_pot);
					System.out.println("--- Die Haelfte des Pots ist: " + einsatzWert);
					System.out.println("--- Der Einsatzwert ist: " + einsatzWert);
				} // else if
			}
			else {
				// sonst folden wir
				action[0] = BetInt.FOLD;
				System.out.println("--- Nr5 hat gefoldet.");
			}
			
			
			// Dummy erstmal alles CALLen
			action[0] = 1;		
		}
		// Runde 2 ist der Turn
		else if (currentRound == 2) {
			System.out.println("--- Runde 2 - Turn Strategie");
			
			// Wieviel wurde zuletzt gecalled ?
			int value_highestbet = state.getHighestBet();
			System.out.println("--- HighestBet: " + value_highestbet);	
			
			// Wieviel wird gecalled ?
			int value_callsize = value_highestbet - state.getPlayers()[0].getCurrentBet();
			System.out.println("--- CallSize: " + value_callsize);
			
			// Analysieren des Bietverhaltens des linken Spielers
			// wenn man mehr raised als zu callen oder zu checken dann aggressive
			// wenn man mehr called oder checked als zu raisen oder zu bieten dann passive
			if (betBehavier[1][3] > (betBehavier[1][1] + betBehavier[1][2])){
				playerBetType[1] = "aggresive";
			}else{
				playerBetType[1] = "passive";
			}
			System.out.println("--- Bietverhalten LeftPlayer: " + playerBetType[1]);
			
			Boolean leftPlayerActive = state.getPlayers()[1].isActive();
			System.out.println("--- leftPlayerActive: " + leftPlayerActive);
			if (leftPlayerActive == true){
				// Name des linken Players
				String leftPlayerName = state.getPlayers()[1].getName();
				System.out.println("--- LeftPlayerName: "+ leftPlayerName);
				
				// Was hat Spieler Links von uns gemacht ?
				for (Action a : state.getRound().getHistory(1)) {
					leftAction[0] = a.toInt();		
					// schreibe zur Analyse die Aktion in ein Array
					if (leftAction[0] == -1) {  //FOLD
						betBehavier[1][0]++;
					}else{
						if(leftAction[0] == 0){  //CHECK
							betBehavier[1][1]++;
						}else{
							if(leftAction[0] == 1){  //CALL
								betBehavier[1][2]++;
							}else{
								if(leftAction[0] == 5){  //RAISE
									betBehavier[1][3]++;
								}
							}
						}
					}
				}
				}
				System.out.println("--- leftAction: " + leftAction[0]);
				
				// Falls wir keine Info haben was in dieser Runde passiert ist, dann holen wir uns die Info aus der Vorrunde
//				if (leftAction[0] == -11) {
//					for (Action a : state.getRound(currentRound - 1).getHistory(1)) {
//						leftAction[0] = a.toInt();				
//					}
//					System.out.println("--- leftAction(lastRound): " + leftAction[0]);
//				}
			
			// Analysieren des Bietverhaltens des rechten Spielers
			// wenn man mehr raised als zu callen oder zu checken dann aggressive
			// wenn man mehr called oder checked als zu raisen oder zu bieten dann passive
			if (betBehavier[2][3] > (betBehavier[2][1] + betBehavier[2][2])){
				playerBetType[2] = "aggresive";
			}else{
				playerBetType[2] = "passive";
			}
			System.out.println("--- Bietverhalten RightPlayer: " + playerBetType[2]);
			
			Boolean rightPlayerActive = state.getPlayers()[2].isActive();
			System.out.println("--- rightPlayerActive: " + rightPlayerActive);
			if (rightPlayerActive == true){
				// Name des rechten Players
				String rightPlayerName = state.getPlayers()[2].getName();
				System.out.println("--- RightPlayerName: "+ rightPlayerName);
				
				// Was hat Spieler Rechts von uns gemacht ?
				for (Action a : state.getRound().getHistory(2)) {
					rightAction[0] = a.toInt();	
					// schreibe zur Analyse die Aktion in ein Array
					if (rightAction[0] == -1) {  //FOLD
						betBehavier[2][0]++;
					}else{
						if(rightAction[0] == 0){  //CHECK
							betBehavier[2][1]++;
						}else{
							if(rightAction[0] == 1){  //CALL
								betBehavier[2][2]++;
							}else{
								if(rightAction[0] == 5){  //RAISE
									betBehavier[2][3]++;
								}
							}
						}
					}
				}
				
				// Falls wir keine Info haben was in dieser Runde passiert ist, dann holen wir uns die Info aus der Vorrunde
//				if (rightAction[0] == -11) {
//					for (Action a : state.getRound(currentRound - 1).getHistory(2)) {
//						rightAction[0] = a.toInt();				
//					}
//					System.out.println("--- rightAction(lastRound): " + rightAction[0]);
//				}	
			}
			
			OutsAndOdds oo = new OutsAndOdds();
			double value_odds = oo.getOdds(state.getCurrentRound(), state.getActivePlayers()[0].getHoleCards(), state.getBoardCards());
			System.out.println("--- Odd: " + value_odds + "%");
			
			// Wir checken mal unsere potOdds (Verhltnis zwischen Einsatz / Pot + Einsatz)
			double value_potOdd = ((double)value_callsize / ((double)value_pot + (double)value_callsize)) * 100;
			System.out.println("--- potOdd: " + value_potOdd + "%");
			
			// STrategie bei Turn
			if (value_odds > value_potOdd) {
				// callen oder checken, also mitgehen
				if (value_callsize == 0) {
					// bieten, es hat noch niemand was gesetzt
				}
				else if (value_callsize > 0) {
					// raisen es wurde was gesetzt
					action[0] = BetInt.RAISE;
					// wieviele aktive Spieler
					int aktiveSpiele = state.getActivePlayers().length;
					//aktuellesGebot + erhhung;
					// Continuationbet
					if (aktiveSpiele < 4) {
						//potsize = value_pot
						//hlfte von potsize
						einsatzWert = value_pot / 2;
					}
					// Handschtzen
					else {
						// ein wert zwischen 3/4 und 1 von der potsize
						einsatzWert = (value_pot / 4) * 3;
						
						Random random = new Random();
						int randomWert = random.nextInt(3);
						
						switch (randomWert) {
						case 0: 
							einsatzWert = einsatzWert + 1;
							break;
						case 1: 
							einsatzWert = einsatzWert - 1;
							break;
						case 2: 
							einsatzWert = einsatzWert + 2;
							break;
						case 3: 
							einsatzWert = einsatzWert - 2;
							break;
						default:
						
						}// switch
						
					} // else
					action[1] = state.getHighestBet() + (int)einsatzWert;
					System.out.println("--- Die Callsize ist groesser als 0 und wir sind weniger als 4 aktive Mitspieler");
					System.out.println("--- Die Groesse des Pots ist: " + value_pot);
					System.out.println("--- Die Haelfte des Pots ist: " + einsatzWert);
					System.out.println("--- Der Einsatzwert ist: " + einsatzWert);
				} // else if
			}
			else {
				// sonst folden wir
				action[0] = BetInt.FOLD;
				System.out.println("--- Nr5 hat gefoldet.");
			}
			
			// Dummy erstmal alles CALLen
			action[0] = 1;		
		}
		// Runde 3 ist der River
		else if (currentRound == 3) {
			System.out.println("--- Runde 3 - River Strategie");
			
			// Wieviel wurde zuletzt gecalled ?
			int value_highestbet = state.getHighestBet();
			System.out.println("--- HighestBet: " + value_highestbet);	
			
			// Wieviel wird gecalled ?
			int value_callsize = value_highestbet - state.getPlayers()[0].getCurrentBet();
			System.out.println("--- CallSize: " + value_callsize);
			
			// Analysieren des Bietverhaltens des rechten Spielers
			// wenn man mehr raised als zu callen oder zu checken dann aggressive
			// wenn man mehr called oder checked als zu raisen oder zu bieten dann passive
			if (betBehavier[1][3] > (betBehavier[1][1] + betBehavier[1][2])){
				playerBetType[1] = "aggresive";
			}else{
				playerBetType[1] = "passive";
			}
			System.out.println("--- Bietverhalten LeftPlayer: " + playerBetType[1]);
			
			Boolean leftPlayerActive = state.getPlayers()[1].isActive();
			System.out.println("--- leftPlayerActive: " + leftPlayerActive);
			if (leftPlayerActive == true){
				// Name des linken Players
				String leftPlayerName = state.getPlayers()[1].getName();
				System.out.println("--- LeftPlayerName: "+ leftPlayerName);
				
				// Was hat Spieler Links von uns gemacht ?
				for (Action a : state.getRound().getHistory(1)) {
					leftAction[0] = a.toInt();	
					// schreibe zur Analyse die Aktion in ein Array
					if (leftAction[0] == -1) {  // FOLD
						betBehavier[1][0]++;
					}else{
						if(leftAction[0] == 0){  // CHECK
							betBehavier[1][1]++;
						}else{
							if(leftAction[0] == 1){  // CALL
								betBehavier[1][2]++;
							}else{
								if(leftAction[0] == 5){  // RAISE
									betBehavier[1][3]++;
								}
							}
						}
					}
				}
				
				// Falls wir keine Info haben was in dieser Runde passiert ist, dann holen wir uns die Info aus der Vorrunde
//				if (leftAction[0] == -11) {
//					for (Action a : state.getRound(currentRound - 1).getHistory(1)) {
//						leftAction[0] = a.toInt();				
//					}
//					System.out.println("--- leftAction(lastRound): " + leftAction[0]);
//				}
			}
			
			// Analysieren des Bietverhaltens des rechten Spielers
			// wenn man mehr raised als zu callen oder zu checken dann aggressive
			// wenn man mehr called oder checked als zu raisen oder zu bieten dann passive
			if (betBehavier[2][3] > (betBehavier[2][1] + betBehavier[2][2])){
				playerBetType[2] = "aggresive";
			}else{
				playerBetType[2] = "passive";
			}
			System.out.println("--- Bietverhalten RightPlayer: " + playerBetType[2]);
			
			// nur wenn der Spieler aktiv ist
			Boolean rightPlayerActive = state.getPlayers()[2].isActive();
			System.out.println("--- rightPlayerActive: " + rightPlayerActive);
			if (rightPlayerActive == true){
				// Name des rechten Players
				String rightPlayerName = state.getPlayers()[2].getName();
				System.out.println("--- RightPlayerName: "+ rightPlayerName);
				
				// Was hat Spieler Rechts von uns gemacht ?
				for (Action a : state.getRound().getHistory(2)) {
					rightAction[0] = a.toInt();		
					
					// schreibe zur Analyse die Aktion in ein Array
					if (rightAction[0] == -1) {  //FOLD
						betBehavier[2][0]++;
					}else{
						if(rightAction[0] == 0){  // CHECK
							betBehavier[2][1]++;
						}else{
							if(rightAction[0] == 1){  //CALL
								betBehavier[2][2]++;
							}else{
								if(rightAction[0] == 5){  //RAISE
									betBehavier[2][3]++;
								}
							}
						}
					}
				}
				
				// Falls wir keine Info haben was in dieser Runde passiert ist, dann holen wir uns die Info aus der Vorrunde
//				if (rightAction[0] == -11) {
//					for (Action a : state.getRound(currentRound - 1).getHistory(2)) {
//						rightAction[0] = a.toInt();				
//					}
//					System.out.println("--- rightAction(lastRound): " + rightAction[0]);
//				}
				}
			
			// Im River brauchen wir die Odds nicht mehr zu berechnen, da keine Karten mehr gezogen werden
			// Wir checken mal unsere potOdds (Verhltnis zwischen Einsatz / Pot + Einsatz)
			double value_potOdd = ((double)value_callsize / ((double)value_pot + (double)value_callsize)) * 100;
			System.out.println("--- potOdds: " + value_potOdd + "%");	
			
			// Dafr berechnen wir jetzt die Wahrscheinlichkeit das die Gegner besser sind, 
			// da wir nun 5 ihrer 7 karten kennen und unser hhstes ergebnis
			meineHoleCards = state.getPlayers()[0].getHoleCards();
			gemeinschaftskarten = state.getBoardCards();
			meineKartenGesamt =  new Card[meineHoleCards.length + gemeinschaftskarten.length];
			int meinErgebnis=meineSituation(meineKartenGesamt);
			System.out.println("--- Ich habe: " + meinErgebnis);
			
			// Strategie bei river
		}
		// Sonstige Runde 
		else {
			System.out.println("--- Runde " + currentRound + " - Random Strategie");
			
			action = getRandomBet();
		}
		
		System.out.println("--- Runde beendet, Nr5 setzt " + action[0]);

		return action;		
	} // bet
	
	
	// Bewertung
	int hoehstesPaar=0;
	int hoehsterDrilling=0;
	int hoehsterVierling=0;
	int flush=-1; // 0 vergeben fr diamont	
	
	
	
	
	
	public int meineSituation(Card[] cards){
		/*
		 *  rank= wertigkeit
		 *  suit = farbe
		 *  
			public static final int DIAMONDS = 0;
		    public static final int HEARTS = 1;
		    public static final int SPADES = 2;
		    public static final int CLUBS = 3;
		    
		    public static final int JACK = 11;
		    public static final int QUEEN = 12;
		    public static final int KING = 13;
		    public static final int ACE = 14;
		 */
		// Test was wir erfllen 
		// meine Karten gesammt
		System.out.println("Hier sind meine Karten:");
		meineKartenGesamt[0]=meineHoleCards[0];
		meineKartenGesamt[1]=meineHoleCards[1];
		System.out.println(meineKartenGesamt[0]);
		System.out.println(meineKartenGesamt[1]);
		
		meineKartenGesamt[2]=gemeinschaftskarten[0];
		meineKartenGesamt[3]=gemeinschaftskarten[1];
		meineKartenGesamt[4]=gemeinschaftskarten[2];
		meineKartenGesamt[5]=gemeinschaftskarten[3];
		meineKartenGesamt[6]=gemeinschaftskarten[4];
		System.out.println(meineKartenGesamt[2]);
		System.out.println(meineKartenGesamt[3]);
		System.out.println(meineKartenGesamt[4]);
		System.out.println(meineKartenGesamt[5]);
		System.out.println(meineKartenGesamt[6]);
			
		
		// Einordnung nach Wert/Farbe
		// 14=Kartenwertigkeitsanzahl, 15, damit das lesen einfacher wird
		int[] anzahlZahl = new int [15];
		int[] anzahlFarbe = new int[4];
		for (int i = 0; i < meineKartenGesamt.length; i++){
			anzahlZahl[meineKartenGesamt[i].getRank()] = anzahlZahl[meineKartenGesamt[i].getRank()] + 1;
			anzahlFarbe[meineKartenGesamt[i].getSuitAsInt()]++;			
		}
		
		// Bewertung
		
		for(int i = 1; i < meineKartenGesamt.length+1; i++){
			if (anzahlZahl[i]>=4){
				hoehsterVierling=i;
			}
			if (anzahlZahl[i]>=3){
				hoehsterDrilling=i;
			}
			if (anzahlZahl[i]>=2){
				hoehstesPaar=i;
			}
		}
		
		for (int j = 0; j<4; j++){
			if (anzahlFarbe[j]==3){
				flush=j;
			}
		}
		/*	hhste Kombi 
			1 = roy.flush
			2 = strg. flush
			3 = vierling
			4 = full house 
			5 = flush
			6 = straight
			7 = drilling
			8 = doppelpaar
			9 = paar
			10= hhste karte
		*/
		int hoehsteKombi=0;
		
		if(royalFlush()){hoehsteKombi=1;}
		else if (straight(kartenMitFarbe(meineKartenGesamt,flush))>0){hoehsteKombi=2;}
		else if (hoehsterVierling>0){hoehsteKombi=3;}
		else if ((hoehsterDrilling>0) && ((hoehstesPaar>0))){hoehsteKombi=4;}
		else if (flush>0){hoehsteKombi=5;}
		else if (straight(meineKartenGesamt)>0){hoehsteKombi=6;}
		else if (hoehsterDrilling>0){hoehsteKombi=7;}
		else if (anzahlPaare(meineKartenGesamt)>=2){hoehsteKombi=8;}
		else if (hoehstesPaar>0){hoehsteKombi=9;}
		else if (hoehsteKarte(meineKartenGesamt)>0){hoehsteKombi=10;}
		
		return hoehsteKombi;
		
	}
	
	private int hoehsteKarte(Card[] cards) {
		int hoehste=0;
		for (int i=0;i<cards.length;i++){
			if(cards[i].getRank()>hoehste){hoehste=cards[i].getRank();}
		}
		return hoehste;
	}

	public int anzahlPaare(Card[] cards){
		int j[]=new int[15];
		for (int i = 0; i<cards.length;i++){
			j[cards[i].getRank()]++;
		}
		int anzahl=0;
		for (int i = 0;i<15;i++){
			if (j[i]>=2){
				anzahl++;
			}
		}
		return anzahl;
	}
	
	public Card[] kartenMitWertigkeit (Card[] cards, int wertigkeit){
		Card [] rueckgabe1 = new Card[cards.length];
		int anzahl=0;
		for (int i = 0; i<cards.length;i++){
			if(cards[i].getRank()==wertigkeit){
				rueckgabe1[anzahl]=cards[i];
			}
		}
		Card [] rueckgabe = new Card[anzahl];
		for (int i = 0; i<anzahl;i++){
			rueckgabe[i]=cards[i];
		}
		return rueckgabe;
	}
	
	public Card[] kartenMitFarbe (Card[] cards, int farbe){
		Card [] rueckgabe1 = new Card[cards.length];
		int anzahl=0;
		for (int i = 0; i<cards.length;i++){
			if(cards[i].getSuitAsInt()==farbe){
				rueckgabe1[anzahl]=cards[i];
			}
		}
		Card [] rueckgabe = new Card[anzahl];
		for (int i = 0; i<anzahl;i++){
			rueckgabe[i]=cards[i];
		}
		return rueckgabe;
	}

	public boolean royalFlush(){
		if (flush>-1){
			int wert=0;
			Card[] royal=kartenMitFarbe(meineKartenGesamt, flush);
			for (int i = 10; i<15;i++){
				if(kartenMitWertigkeit(royal,i).length>0){
					wert++;
				}
			}			
			if(wert==5){return true;}
		}
		
		return false;		
	}
	
	public int straight(Card[] cards){
		int straight=0;
		for (int j=1;j<16;j++){
			int zaehler[]=new int[5];
			for(int i=0; i<cards.length;i++){
				int beginn1=j;
				if (cards[i].getRank()==beginn1){zaehler[0]=beginn1;}
				beginn1++;
				if(beginn1>14){beginn1=14-beginn1;}
				if (cards[i].getRank()==beginn1){zaehler[1]=beginn1;}
				beginn1++;
				if(beginn1>14){beginn1=14-beginn1;}
				if (cards[i].getRank()==beginn1){zaehler[2]=beginn1;}
				beginn1++;
				if(beginn1>14){beginn1=14-beginn1;}
				if (cards[i].getRank()==beginn1){zaehler[3]=beginn1;}
				beginn1++;
				if(beginn1>14){beginn1=14-beginn1;}
				if (cards[i].getRank()==beginn1){zaehler[4]=beginn1;}
			}
			int zaehler1=0;
			for (int i=0; i<5;i++){
				if (zaehler[i]>0){zaehler1++;}
			}
			
			if (zaehler1==5){straight=j;}
		}
		
		return straight;
	}

}

/*
 * public static final int INVALID = -11;
	public static final int FOLD = -1;
	public static final int CHECK = 0;
	public static final int CALL = 1;
	public static final int CALL20 = 20;
	public static final int MINRAISE = 2;
	public static final int RAISE3 = 3;
	public static final int RAISE4 = 4;
	public static final int RAISE = 5;
	public static final int ALLIN = 9;
	public static final int NA = -2;
	*/
