package bot;

import game.model.Card;
import glassfrog.model.Gamedef;

/**
 * Specifies the methods that can be called by a Talk object to trigger the bot to update the state.
 * @author Witthold/Korol
 */
public interface IF_Bot_Talk {
	
	public String getName();
	public int getBuyin();
	public boolean newGame(Gamedef gamedef);
	public void handleStateChange();
	public void newRound();
	public void setBlinds();
	public void setBoardCards(int round, Card[] cards);
	public void endLastRound(Card[][] holeCards);
	public void showdown(String[] winner, int[] amount);
	public void showdown(int[] winsPerPlayer);
	public void addAction(int round, char action);
	public void addAction(int round, char action, int finalInPot);	
	public void gameOver();
}
