package bot;

import game.model.Card;

import org.drools.runtime.rule.FactHandle;

import util.DebugOut;

import bot.module.equity.IF_Equity;

/**
 * Basic example bot which implements its strategy with drools.
 * @author Witthold/Korol
 *
 */
public class HSBremen2 extends DroolsBot {

	public HSBremen2(String config) {
		super(config);
	}

	@Override
	public int[] getBet() {
			
			int potSize = state.getPotSize();
			int callSize = state.getHighestBet() - state.getPlayers()[0].getCurrentBet();
	
			Card[][] holeCards = new Card[state.getActivePlayers().length][];
			Card[] boardCards = state.getBoardCards();
			Card[] deadCards = state.getDeadCards();
			
			
			for (int i = 0; i < holeCards.length; i++) {
				
				holeCards[i] = state.getActivePlayers()[i].getHoleCards();
			}
	
			double equity = ((IF_Equity)equities.get(0)).getEquity(1000, 1000, holeCards, boardCards, deadCards)[0];
			
			float potOdds = ((float)callSize / ((float)potSize + (float)callSize));
			
			PotEquity pe = new PotEquity();
			pe.setEquity(equity);
			pe.setPotOdds(potOdds);
			
			FactHandle arg0 = ksession.insert(pe);
			ksession.fireAllRules();
			ksession.retract(arg0);
			
			if(pe.getResult()) {
						
				return new int[]{1,0};	
			
			} else {

				return new int[]{-1,0};
			}
		}

	@Override
	protected boolean isPlayable() {
	
		return true;
	}
	
	
	public static void main(String[] args) throws Exception {
		String config = "default.config";
		try {
			if (args != null) {
				if (args.length > 0) {
					DebugOut.showVerboseMain(args[0]);
					config = args[0] + ".config";
				}
			}
		} finally {
			Bot bot = new HSBremen2(config);
			bot.run();
		}
	}
}