package bot;

import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderError;
import org.drools.builder.KnowledgeBuilderErrors;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.io.ResourceFactory;
import org.drools.logger.KnowledgeRuntimeLogger;
import org.drools.logger.KnowledgeRuntimeLoggerFactory;
import org.drools.runtime.StatefulKnowledgeSession;

/**
 * Foundation of a bot which wants to implement its strategy via drools.
 * @author Witthold/Korol
 *
 */
public abstract class DroolsBot extends Bot {

	protected KnowledgeBase kbase;
	protected StatefulKnowledgeSession ksession;
	protected KnowledgeRuntimeLogger logger;
	
	
	/**
	 * Builds and returns a KnowledgeBase.</br>
	 * (Needed for drools) 
	 * @return	New KnowledgeBase
	 */
	protected static KnowledgeBase readKnowledgeBase() throws Exception {
		KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
		kbuilder.add(ResourceFactory.newClassPathResource("Bot.drl"), ResourceType.DRL);
		KnowledgeBuilderErrors errors = kbuilder.getErrors();
		if (errors.size() > 0) {
			for (KnowledgeBuilderError error: errors) {
				System.err.println(error);
			}
			throw new IllegalArgumentException("Could not parse knowledge.");
		}
		KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
		kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
		return kbase;
	}
	
	/**
	 * Build a new bot with the config string and initializes drools.
	 * @param config	Configuration for the constructor of bot.Bot
	 */
	public DroolsBot(String config) {
		super(config);

		try {
			// load up the knowledge base
			kbase = readKnowledgeBase();
			ksession = kbase.newStatefulKnowledgeSession();
			logger = KnowledgeRuntimeLoggerFactory.newFileLogger(ksession, "test");
			// go !
			logger.close();
		} catch (Throwable t) {
			t.printStackTrace();
		}
	}

	public class PotEquity {
		
		public double equity;
		public double potOdds;
		
		public boolean result;
		
		public double getEquity() {
			return this.equity;
		}
		
		public void setEquity(double equity) {
			this.equity = equity;
		}
		
		public double getPotOdds() {
			return this.potOdds;
		}
		
		public void setPotOdds(double potOdds) {
			this.potOdds = potOdds;
		}
		
		public boolean getResult() {
			return this.result;
		}
		
		public void setResult(boolean result) {
			this.result = result;
		}
	}
}