
DROP TABLE IF EXISTS action;
DROP TABLE IF EXISTS card_of_player;
DROP TABLE IF EXISTS competition_player_map;
DROP TABLE IF EXISTS card_common;
DROP TABLE IF EXISTS round;
DROP TABLE IF EXISTS hand_player_map;
DROP TABLE IF EXISTS hand;
DROP TABLE IF EXISTS competition;
DROP TABLE IF EXISTS gamedef;
DROP TABLE IF EXISTS player;

CREATE TABLE player (
       id INT UNSIGNED NOT NULL AUTO_INCREMENT
     , alias VARCHAR(50) NOT NULL
     , PRIMARY KEY (id)
) ENGINE=InnoDB;

CREATE TABLE gamedef (
       id INT UNSIGNED NOT NULL AUTO_INCREMENT
     , limited TINYINT(1) NOT NULL
     , minBet MEDIUMINT UNSIGNED NOT NULL
     , maxBet MEDIUMINT UNSIGNED
     , num_players TINYINT(2) NOT NULL
     , style TINYINT(1) NOT NULL
     , buyin MEDIUMINT UNSIGNED NOT NULL
     , PRIMARY KEY (id)
) ENGINE=InnoDB;
ALTER TABLE gamedef MODIFY COLUMN limited TINYINT(1) NOT NULL
      COMMENT 'limited:1; pot-limit:0; no-limit: -1';
ALTER TABLE gamedef MODIFY COLUMN style TINYINT(1) NOT NULL
      COMMENT 'cash:1; tournament:2; doyle:3;';

CREATE TABLE competition (
       id INT UNSIGNED NOT NULL AUTO_INCREMENT
     , gamedef_id INT UNSIGNED NOT NULL
     , PRIMARY KEY (id)
     , INDEX (gamedef_id)
     , CONSTRAINT FK_competition_1 FOREIGN KEY (gamedef_id)
                  REFERENCES gamedef (id)
) ENGINE=InnoDB;

CREATE TABLE hand (
       id INT UNSIGNED NOT NULL AUTO_INCREMENT
     , sb SMALLINT UNSIGNED NOT NULL
     , bb SMALLINT UNSIGNED NOT NULL
     , ante SMALLINT UNSIGNED NOT NULL
     , finalpot MEDIUMINT UNSIGNED
     , competition_id INT UNSIGNED NOT NULL
     , PRIMARY KEY (id)
     , INDEX (competition_id)
     , CONSTRAINT FK_hand_1 FOREIGN KEY (competition_id)
                  REFERENCES competition (id)
) ENGINE=InnoDB;

CREATE TABLE hand_player_map (
       id INT UNSIGNED NOT NULL AUTO_INCREMENT
     , position TINYINT(2) NOT NULL
     , cash_init MEDIUMINT UNSIGNED NOT NULL
     , cash_delta MEDIUMINT
     , player_id INT UNSIGNED NOT NULL
     , hand_id INT UNSIGNED NOT NULL
     , PRIMARY KEY (id)
     , INDEX (player_id)
     , CONSTRAINT FK_player_match_map_1 FOREIGN KEY (player_id)
                  REFERENCES player (id)
     , INDEX (hand_id)
     , CONSTRAINT FK_participation_4 FOREIGN KEY (hand_id)
                  REFERENCES hand (id)
) ENGINE=InnoDB;

CREATE TABLE round (
       id INT UNSIGNED NOT NULL AUTO_INCREMENT
     , timestamp BIGINT UNSIGNED NOT NULL
     , hand_id INT UNSIGNED NOT NULL
     , PRIMARY KEY (id)
     , INDEX (hand_id)
     , CONSTRAINT FK_round_card_1 FOREIGN KEY (hand_id)
                  REFERENCES hand (id)
) ENGINE=InnoDB;

CREATE TABLE card_common (
       value TINYINT(2) NOT NULL
     , round_id INT UNSIGNED NOT NULL
     , INDEX (round_id)
     , CONSTRAINT FK_card_1 FOREIGN KEY (round_id)
                  REFERENCES round (id)
) ENGINE=InnoDB;
ALTER TABLE card_common MODIFY COLUMN value TINYINT(2) NOT NULL
      COMMENT 'suit: +20, val: +val // Ac: 3x20+14=74 // 2d: 0x20+2=2';

CREATE TABLE competition_player_map (
       cash_init MEDIUMINT UNSIGNED NOT NULL
     , rank SMALLINT UNSIGNED
     , player_id INT UNSIGNED NOT NULL
     , competition_id INT UNSIGNED NOT NULL
     , INDEX (competition_id)
     , CONSTRAINT FK_player_in_competition_1 FOREIGN KEY (competition_id)
                  REFERENCES competition (id)
     , INDEX (player_id)
     , CONSTRAINT FK_player_in_competition_2 FOREIGN KEY (player_id)
                  REFERENCES player (id)
) ENGINE=InnoDB;

CREATE TABLE card_of_player (
       id INT UNSIGNED NOT NULL AUTO_INCREMENT
     , value TINYINT(2) NOT NULL
     , hand_player_map_id INT UNSIGNED NOT NULL
     , PRIMARY KEY (id)
     , INDEX (hand_player_map_id)
     , CONSTRAINT FK_card_of_player_1 FOREIGN KEY (hand_player_map_id)
                  REFERENCES hand_player_map (id)
) ENGINE=InnoDB;
ALTER TABLE card_of_player MODIFY COLUMN value TINYINT(2) NOT NULL
      COMMENT 'suit: +20, val: +val // Ac: 3x20+14=74 // 2d: 0x20+2=2';

CREATE TABLE action (
       id BIGINT UNSIGNED NOT NULL AUTO_INCREMENT
     , action TINYINT(1) NOT NULL
     , betsize MEDIUMINT UNSIGNED NOT NULL
     , potsize MEDIUMINT UNSIGNED NOT NULL
     , timestamp BIGINT UNSIGNED NOT NULL
     , round_id INT UNSIGNED NOT NULL
     , player_id INT UNSIGNED NOT NULL
     , PRIMARY KEY (id)
     , INDEX (player_id)
     , CONSTRAINT FK_bet_2 FOREIGN KEY (player_id)
                  REFERENCES player (id)
     , INDEX (round_id)
     , CONSTRAINT FK_bet_3 FOREIGN KEY (round_id)
                  REFERENCES round (id)
) ENGINE=InnoDB;
ALTER TABLE action MODIFY COLUMN action TINYINT(1) NOT NULL
      COMMENT 'Fold: -1, Check: 0, Call: 1, Raise: 5, Allin: 9';


