#include <jni.h>
#include <stdio.h>
#include <iostream>
#include <vector>
#include "extmodule_JNI_Feed.h"

using namespace std;

JNIEXPORT jboolean JNICALL Java_extmodule_JNI_1Feed_initModule
  (JNIEnv *env, jobject obj, jintArray betSizes_in, jintArray betStructure_in, jintArray blindStructure_in, jint ante_in, jstring playerNames_in, jintArray cashOfPlayers_in) {

        printf("initModule:\n###\n");
        printf("betSizes:\n");

        int len = env->GetArrayLength(betSizes_in);
        int *body = env->GetIntArrayElements(betSizes_in, 0);
        int betSizes[len];

        for (int i = 0; i<len; i++) {

                betSizes[i] = body[i];
                cout << i << ": " << betSizes[i] << "\n";
        }
        env->ReleaseIntArrayElements(betSizes_in, body, 0);

	printf("\n");

	printf("betStructure:\n");

	len = env->GetArrayLength(betStructure_in);
        body = env->GetIntArrayElements(betStructure_in, 0);
        int betStructure[len];

	for (int i = 0; i<len; i++) {

                betStructure[i] = body[i];
                cout << i << ": " << betStructure[i] << "\n";
        }

        env->ReleaseIntArrayElements(betStructure_in, body, 0);

        printf("\n");

	printf("blindStructure:\n");

	len = env->GetArrayLength(blindStructure_in);
        body = env->GetIntArrayElements(blindStructure_in, 0);
        int blindStructure[len];

        for (int i = 0; i<len; i++) {

                blindStructure[i] = body[i];
                cout << i << ": " << blindStructure[i] << "\n";
        }
        
        env->ReleaseIntArrayElements(blindStructure_in, body, 0);

        printf("\n");

	cout << "ante: " << ante_in << "\n\n";

	printf("players:\n");

	vector<string> playerNames = vector<string>();

	string str = env->GetStringUTFChars(playerNames_in, false);

	int cutAt;
	while( (cutAt = str.find_first_of(" ")) != str.npos )
	{
		if(cutAt > 0)
		{
			playerNames.push_back(str.substr(0,cutAt));
		}
		str = str.substr(cutAt+1);
	}
	if(str.length() > 0)
	{
		playerNames.push_back(str);
	}

	len = env->GetArrayLength(cashOfPlayers_in);
        body = env->GetIntArrayElements(cashOfPlayers_in, 0);
        int cashOfPlayers[len];

        for (int i = 0; i<len; i++) {

                cashOfPlayers[i] = body[i];
                cout << playerNames[i] << ": " << cashOfPlayers[i] << "$\n";
        }

        env->ReleaseIntArrayElements(cashOfPlayers_in, body, 0);

        printf("\n");
}

JNIEXPORT void JNICALL Java_extmodule_JNI_1Feed_newHand (JNIEnv *env, jobject obj, jint button_in) {

	printf("newHand():\n###\n");
        cout << "button: " << button_in << "\n";

        printf("\n");
        return;
}

JNIEXPORT void JNICALL Java_extmodule_JNI_1Feed_newHoleCards (JNIEnv *env, jobject obj, jint player_in, jintArray cards_in) {

        printf("newHoleCards():\n###\n");

        cout << "player: " << player_in << "\n";
        printf("cards:\n");

	int len = env->GetArrayLength(cards_in);
        int *body = env->GetIntArrayElements(cards_in, 0);
        int cards[len];

        for (int i = 0; i<len; i++) {

                cards[i] = body[i];
                cout << i << ": " << cards[i] << "\n";
        }
        env->ReleaseIntArrayElements(cards_in, body, 0);

        printf("\n");
	return;
}

JNIEXPORT void JNICALL Java_extmodule_JNI_1Feed_newAction (JNIEnv *env, jobject obj, jobject action_in) {

        printf("newAction():\n###\n");

	jclass jcls = (*env).GetObjectClass(action_in);
        jmethodID getActionID = (*env).GetMethodID(jcls, "getAction", "()C");
        jmethodID getChangeID = (*env).GetMethodID(jcls, "getChange", "()I");
        jmethodID getPlayerID = (*env).GetMethodID(jcls, "getPlayer", "()I");

	int player = (*env).CallIntMethod(action_in, getPlayerID);
	char action = (*env).CallCharMethod(action_in, getActionID);
	int change = (*env).CallIntMethod(action_in, getChangeID);

	cout << "action: P" << player << ": " << action << change << "\n";

        printf("\n");
	return;
}

JNIEXPORT void JNICALL Java_extmodule_JNI_1Feed_newRound (JNIEnv *env, jobject obj, jint round_in, jintArray newCards_in) {

        printf("newRound():\n###\n");

	cout << "round: " << round_in << "\n";

        printf("newCards:\n");

	int len = env->GetArrayLength(newCards_in);
        int *body = env->GetIntArrayElements(newCards_in, 0);
        int newCards[len];

        for (int i = 0; i<len; i++) {

                newCards[i] = body[i];
                cout << i << ": " << newCards[i] << "\n";
        }
        env->ReleaseIntArrayElements(newCards_in, body, 0);

        printf("\n");
	return;
}

JNIEXPORT void JNICALL Java_extmodule_JNI_1Feed_showdown (JNIEnv *env, jobject obj, jint player_in, jint gain_in) {

        printf("showdown():\n###\n");

        cout << "player: " << player_in << ": +" << gain_in << "\n";

        printf("\n");
	return;
}
