#ifndef CARD_H
#define CARD_H
#include <string>
#include <iostream>

class Card
{
public:

	Card()
	{
		value=0;
	};

	Card(int value_)
	{
		if(value_<0 || value_>52)
		{
			fprintf(stderr, "Cardvalue does not exist. Wrong Cardvalue: %i\n", value_);
			
		}
		value=value_;
	};

	Card(std::string value_s)
	{
		if(value_s[0]=='A')
		{
			value=1;
		}
		else if(value_s[0]=='2')
		{
			value=2;
		}
		else if(value_s[0]=='3')
		{
			value=3;
		}
		else if(value_s[0]=='4')
		{
			value=4;
		}
		else if(value_s[0]=='5')
		{
			value=5;
		}
		else if(value_s[0]=='6')
		{
			value=6;
		}
		else if(value_s[0]=='7')
		{
			value=7;
		}
		else if(value_s[0]=='8')
		{
			value=8;
		}
		else if(value_s[0]=='9')
		{
			value=9;
		}
		else if(value_s[0]=='T')
		{
			value=10;
		}
		else if(value_s[0]=='J')
		{
			value=11;
		}
		else if(value_s[0]=='Q')
		{
			value=12;
		}
		else if(value_s[0]=='K')
		{
			value=13;
		}
		else
		{
			fprintf(stderr, "Card range does not exist. Wrong Cardvalue: *%s*\n", value_s.c_str());
			
		}

		if(value_s[1]=='h')
		{
			value+=26;
		}
		else if(value_s[1]=='d')
		{
			value+=13;
		}
		else if(value_s[1]=='s')
		{
			value+=39;
		}
		else if(value_s[1]=='c')
		{
			value+=0;
		}
		else
		{
			fprintf(stderr, "Card color does not exist. Wrong Cardvalue: %s\n", value_s.c_str());
			
		}
	};

	~Card()
	{
	};

	int setValue(int value_)
	{
		if(value_<0 || value_>52)
		{
			fprintf(stderr, "Cardvalue does not exist. Wrong Cardvalue: %i\n", value_);
			
		}
		value=value_;
		return value;
	};

	int setValue(std::string value_s)
	{
		if(value_s[0]=='A')
		{
			value=1;
		}
		else if(value_s[0]=='2')
		{
			value=2;
		}
		else if(value_s[0]=='3')
		{
			value=3;
		}
		else if(value_s[0]=='4')
		{
			value=4;
		}
		else if(value_s[0]=='5')
		{
			value=5;
		}
		else if(value_s[0]=='6')
		{
			value=6;
		}
		else if(value_s[0]=='7')
		{
			value=7;
		}
		else if(value_s[0]=='8')
		{
			value=8;
		}
		else if(value_s[0]=='9')
		{
			value=9;
		}
		else if(value_s[0]=='T')
		{
			value=10;
		}
		else if(value_s[0]=='J')
		{
			value=11;
		}
		else if(value_s[0]=='Q')
		{
			value=12;
		}
		else if(value_s[0]=='K')
		{
			value=13;
		}
		else
		{
			fprintf(stderr, "Card range does not exist. Wrong Cardvalue: %s\n", value_s.c_str());
			//
		}

		if(value_s[1]=='h')
		{
			value+=26;
		}
		else if(value_s[1]=='d')
		{
			value+=13;
		}
		else if(value_s[1]=='s')
		{
			value+=39;
		}
		else if(value_s[1]=='c')
		{
			value+=0;
		}
		else
		{
			fprintf(stderr, "Card color does not exist. Wrong Cardvalue: %s\n", value_s.c_str());
			//
		}
		return value;
	};

	int getValue()
	{
		if(value<0 || value>52)
		{
			fprintf(stderr, "Cardvalue does not exist. Wrong Cardvalue: %i\n", value);
			
		}
		return value;
	};

	int getSuit()
	{
		if(value<0 || value>52)
		{
			fprintf(stderr, "Cardvalue does not exist. Wrong Cardvalue: %i\n", value);
			
		}
		return (value-1)/13;;
	};

	int getRange()
	{
		if(value<0 || value>52)
		{
			fprintf(stderr, "Cardvalue does not exist. Wrong Cardvalue: %i\n", value);
			
		}
		return (value-1)%13+1;
	};

	std::string getName()
	{
		//1 to 13 -> Kreuz/clubs, 14 to 26 -> Karo/diamonds, 27 to 39 -> Herz/hearts, 40 -> 52 Pik/spades

		std::string name = "";
		int suit = (value-1)/13;
		int range = (value-1)%13+1;

		if(range==0)
			name = ' ';
		else if(range==1)
			name = 'A';
		else if(range==2)
			name = '2';
		else if(range==3)
			name = '3';
		else if(range==4)
			name = '4';
		else if(range==5)
			name = '5';
		else if(range==6)
			name = '6';
		else if(range==7)
			name = '7';
		else if(range==8)
			name = '8';
		else if(range==9)
			name = '9';
		else if(range==10)
			name = 'T';
		else if(range==11)
			name = 'J';
		else if(range==12)
			name = 'Q';
		else if(range==13)
			name = 'K';
		else
		{
			fprintf(stderr, "Card range does not exist. Wrong Cardvalue: %i\n", value);
			
		}

		if(range==0)
			name += ' ';
		else if(suit==0)
			name += 'c';
		else if(suit==1)
			name += 'd';
		else if(suit==2)
			name += 'h';
		else if(suit==3)
			name += 's';
		else
		{
			fprintf(stderr, "Card color does not exist. Wrong Cardvalue: %i\n", value);
			
		}

		return name;
	};

private:
   int value;
};

class HoleCards
{
public:
	HoleCards()
	{
		with_suit = true;
	};

	HoleCards(int card1, int card2)
	{
		cards[0].setValue(card1);
		cards[1].setValue(card2);
		with_suit = true;
	};

	HoleCards(int card1, int card2, bool with_suit_)
	{
		cards[0].setValue(card1);
		cards[1].setValue(card2);
		with_suit = with_suit_;
	};

	HoleCards(Card card1, Card card2)
	{
		cards[0].setValue(card1.getValue());
		cards[1].setValue(card2.getValue());
		with_suit = true;
	};

	HoleCards(Card card1, Card card2, bool with_suit_)
	{
		cards[0].setValue(card1.getValue());
		cards[1].setValue(card2.getValue());
		with_suit = with_suit_;
	};
	
	~HoleCards()
	{
	};
	
	std::string getName()
	{
		if(with_suit)
		{
			if(cards[0].getRange()!=1 && cards[0].getRange()<cards[1].getRange())
				return (cards[1].getName() + " " + cards[0].getName());
			else
				return (cards[0].getName() + " " + cards[1].getName());
		}
		else
		{
			std::string card1 = cards[0].getName();
			std::string card2 = cards[1].getName();
			std::string both_cards = "";
			if(cards[0].getRange()!=1 && (cards[1].getRange()==1
											|| cards[0].getRange()<cards[1].getRange()))
			{
				both_cards += card2[0];
				both_cards += card1[0];
			}
			else
			{
				both_cards += card1[0];
				both_cards += card2[0];
			}
			if(suited())
				both_cards += "s ";
			else
				both_cards += "  ";
			return both_cards;
		}
	}

	bool suited()
	{
		return (cards[0].getSuit()==cards[1].getSuit());
	}

	Card cards[2];
	bool with_suit;
};

#endif
