package glassfrog.server;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.Socket;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * Opens a room with the parameters configured by the private fields.</br>
 * Added for a better work flow during development.
 * @author Witthold/Korol
 */
public class MatchConstructor {
	
	private Socket s;
	private PrintWriter pw;
	private String ip = "127.0.0.1";
	private int port = 9000;
	
	private DateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
	private Date date = new Date();
	private String name = dateFormat.format(date);
	private int hands = 50;
//	private int hands = 10;
	
	//private String gamedefPath = "2Player.limit.gamedef.xml";
	private String gamedefPath = "3Player.limit.gamedef.xml";

//	private String gamedefPath = "2Player.nolimit.gamedef.xml";
//	private String gamedefPath = "3Player.nolimit.gamedef.xml";
//	private String gamedefPath = "4Player.nolimit.gamedef.xml";
	private int seed = (int)(Math.random()*1000);	
	
	private String message;	
	private String tk = ":"; 
	 
	
	public MatchConstructor(){
		System.out.println("MatchConstructor()");

		try{
			s = new Socket(ip, port);
			this.pw = new PrintWriter(s.getOutputStream());
			initRoom();			
	        pw.close();
	        s.close();	
		}catch(IOException e){
			System.out.println("ERROR: MatchConstructor.: " + e.getMessage());
		}        
	}
	
	private void initRoom(){
    	
    	/* has to be like this:
    	"NEW:1274902810:500:2Player.limit.gamedef.xml:42:AAAIPLAYER aip1 1000 127.0.0.1 scripts/startme.sh"
    	*/
    	
    	/* open a room */
    	message = "NEW:"+name+tk+hands+tk+gamedefPath+tk+seed+tk;
    	
    	/* add AAAIPLAYER */
    	//message += "AAAIPLAYER aip1 1000 127.0.0.1 scripts/startme.sh";  
    	
    	/* needs linebreak for finishing communication */
    	message += "\r\n";
    	
    	System.out.println("MatchConstructor sent: " + message);
    	
    	pw.print(message);    	
    } 
	
	public static void main(String[] args){
		System.out.println("MatchConstructor.main");
		
		new MatchConstructor();
	}
}