/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.common.BaseNode;
import org.drools.core.util.ObjectHashMap;
import org.drools.core.util.ReflectiveVisitor;
import org.drools.eclipse.editors.rete.model.Connection;
import org.drools.eclipse.editors.rete.model.ReteGraph;
import org.drools.reteoo.BaseVertex;
import org.drools.reteoo.EntryPointNode;
import org.drools.reteoo.LeftTupleSink;
import org.drools.reteoo.LeftTupleSource;
import org.drools.reteoo.ObjectSource;
import org.drools.reteoo.Rete;
import org.drools.reteoo.ReteVertex;
import org.drools.reteoo.ReteooRuleBase;

public class ReteooVisitor
extends ReflectiveVisitor {
    private static final String PACKAGE_NAME = "org.drools.reteoo.";
    private final Map visitedNodes = new HashMap();
    private ReteGraph graph;
    private BaseVertex rootVertex;
    private BaseVertex parentVertex;

    public ReteooVisitor(ReteGraph reteGraph) {
        this.graph = reteGraph;
    }

    public ReteGraph getGraph() {
        return this.graph;
    }

    public BaseVertex getRootVertex() {
        return this.rootVertex;
    }

    public void visitReteooRuleBase(ReteooRuleBase reteooRuleBase) {
        this.visit(reteooRuleBase.getRete());
    }

    public void visitRete(Rete rete) {
        this.rootVertex = (ReteVertex)this.visitedNodes.get(ReteooVisitor.dotId(rete));
        if (this.rootVertex == null) {
            this.rootVertex = new ReteVertex(rete);
            this.visitedNodes.put(ReteooVisitor.dotId(rete), this.rootVertex);
        }
        this.graph.addChild(this.rootVertex);
        this.parentVertex = this.rootVertex;
        for (EntryPointNode entryPointNode : rete.getEntryPointNodes().values()) {
            this.visit(entryPointNode);
        }
    }

    public void visitBaseNode(BaseNode baseNode) {
        BaseVertex baseVertex = (BaseVertex)this.visitedNodes.get(ReteooVisitor.dotId(baseNode));
        if (baseVertex == null) {
            List<LeftTupleSink> list;
            Object object;
            try {
                object = baseNode.getClass().getName();
                object = String.valueOf(((String)object).substring(((String)object).lastIndexOf(46) + 1)) + "Vertex";
                list = Class.forName(PACKAGE_NAME + (String)object);
                baseVertex = (BaseVertex)((Class)((Object)list)).getConstructor(baseNode.getClass()).newInstance(baseNode);
            }
            catch (Exception exception) {
                throw new RuntimeException("problem visiting vertex " + baseNode.getClass().getName(), exception);
            }
            this.graph.addChild(baseVertex);
            this.visitedNodes.put(ReteooVisitor.dotId(baseNode), baseVertex);
            new Connection(this.parentVertex, baseVertex);
            object = this.parentVertex;
            this.parentVertex = baseVertex;
            list = null;
            if (baseNode instanceof EntryPointNode) {
                list = new ArrayList(((EntryPointNode)baseNode).getObjectTypeNodes().values());
            } else if (baseNode instanceof ObjectSource) {
                list = Arrays.asList(((ObjectSource)baseNode).getSinkPropagator().getSinks());
            } else if (baseNode instanceof LeftTupleSource) {
                list = Arrays.asList(((LeftTupleSource)baseNode).getSinkPropagator().getSinks());
            }
            if (list != null) {
                for (Object e : list) {
                    this.visitNode(e);
                }
            }
            this.parentVertex = object;
        } else {
            new Connection(this.parentVertex, baseVertex);
        }
    }

    private void visitNode(Object object) {
        Object object2 = object;
        if (object instanceof ObjectHashMap.ObjectEntry) {
            ObjectHashMap.ObjectEntry objectEntry = (ObjectHashMap.ObjectEntry)object;
            object2 = objectEntry.getValue();
        }
        this.visit(object2);
    }

    private static String dotId(Object object) {
        return Integer.toHexString(System.identityHashCode(object)).toUpperCase();
    }
}

