/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.wizard.rule;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.text.DateFormat;
import java.util.Date;
import java.util.regex.Pattern;

public class DRLGenerator {
    private static final Pattern packageDec = Pattern.compile("\\$package\\$");
    private static final Pattern dateDec = Pattern.compile("\\$date\\$");
    private static final Pattern functionsDec = Pattern.compile("\\$functions\\$");
    private static final Pattern expanderDec = Pattern.compile("\\$expander\\$");

    public InputStream generateRule(String string, InputStream inputStream) throws IOException {
        String string2 = this.readTemplate(inputStream);
        string2 = this.doHeader(string, string2);
        return this.toStream(string2);
    }

    public InputStream generatePackage(String string, boolean bl, boolean bl2, InputStream inputStream) throws IOException {
        String string2 = this.readTemplate(inputStream);
        string2 = this.doHeader(string, string2);
        string2 = bl ? functionsDec.matcher(string2).replaceFirst("function myFunction( ... ) {" + System.getProperty("line.separator") + "    #function content (can have multiple functions) " + System.getProperty("line.separator") + "}" + System.getProperty("line.separator")) : functionsDec.matcher(string2).replaceFirst("");
        string2 = bl2 ? expanderDec.matcher(string2).replaceFirst("expander customLanguage.dsl" + System.getProperty("line.separator")) : expanderDec.matcher(string2).replaceFirst("");
        return this.toStream(string2);
    }

    private ByteArrayInputStream toStream(String string) throws UnsupportedEncodingException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes("UTF-8"));
        return byteArrayInputStream;
    }

    private String doHeader(String string, String string2) {
        string2 = packageDec.matcher(string2).replaceFirst("package " + string + System.getProperty("line.separator"));
        string2 = dateDec.matcher(string2).replaceFirst(DateFormat.getDateInstance().format(new Date()));
        return string2;
    }

    private String readTemplate(InputStream inputStream) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        String string = null;
        StringBuffer stringBuffer = new StringBuffer();
        while ((string = bufferedReader.readLine()) != null) {
            stringBuffer.append(String.valueOf(string) + System.getProperty("line.separator"));
        }
        String string2 = stringBuffer.toString();
        return string2;
    }
}

