/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.wizard.dsl;

import java.io.IOException;
import java.io.InputStream;
import org.drools.eclipse.DroolsEclipsePlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.ide.IDE;

public class NewDSLFilePage
extends WizardNewFileCreationPage {
    private IWorkbench workbench;

    public NewDSLFilePage(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
        super("createDSLFilePage", iStructuredSelection);
        this.setTitle("New DSL");
        this.setDescription("Create a new Domain Specific Language configuration");
        this.workbench = iWorkbench;
    }

    public void createControl(Composite composite) {
        super.createControl(composite);
        this.setPageComplete(true);
    }

    public boolean finish() {
        IFile iFile;
        String string = this.getFileName();
        if (!string.endsWith(".dsl")) {
            this.setFileName(String.valueOf(string) + ".dsl");
        }
        if ((iFile = this.createNewFile()) == null) {
            return false;
        }
        try {
            IWorkbenchWindow iWorkbenchWindow = this.workbench.getActiveWorkbenchWindow();
            IWorkbenchPage iWorkbenchPage = iWorkbenchWindow.getActivePage();
            if (iWorkbenchPage != null) {
                IDE.openEditor((IWorkbenchPage)iWorkbenchPage, (IFile)iFile, (boolean)true);
            }
        }
        catch (PartInitException partInitException) {
            DroolsEclipsePlugin.log(partInitException);
            return false;
        }
        return true;
    }

    protected InputStream getInitialContents() {
        try {
            return DroolsEclipsePlugin.getDefault().getBundle().getResource("org/drools/eclipse/wizard/dsl/template.dsl").openStream();
        }
        catch (IOException iOException) {
            return null;
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }
}

