/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.wizard.decisiontable;

import java.io.IOException;
import java.io.InputStream;
import org.drools.eclipse.DroolsEclipsePlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.ide.IDE;

public class NewDTFilePage
extends WizardNewFileCreationPage {
    private static final String XLS_EXTENSION = ".xls";
    private IWorkbench workbench;

    public NewDTFilePage(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
        super("createDTFilePage", iStructuredSelection);
        this.setTitle("New Decision Table");
        this.setDescription("Create a new Decision Table scaffolding.");
        this.workbench = iWorkbench;
    }

    public void createControl(Composite composite) {
        super.createControl(composite);
        this.setPageComplete(true);
    }

    public boolean finish() {
        IFile iFile;
        String string = this.getFileName();
        if (!string.endsWith(XLS_EXTENSION)) {
            this.setFileName(String.valueOf(string) + XLS_EXTENSION);
        }
        if ((iFile = this.createNewFile()) == null) {
            return false;
        }
        try {
            IWorkbenchWindow iWorkbenchWindow = this.workbench.getActiveWorkbenchWindow();
            IWorkbenchPage iWorkbenchPage = iWorkbenchWindow.getActivePage();
            if (iWorkbenchPage != null) {
                IDE.openEditor((IWorkbenchPage)iWorkbenchPage, (IFile)iFile, (boolean)true);
            }
        }
        catch (PartInitException partInitException) {
            DroolsEclipsePlugin.log(partInitException);
            return false;
        }
        return true;
    }

    protected InputStream getInitialContents() {
        try {
            return DroolsEclipsePlugin.getDefault().getBundle().getResource("org/drools/eclipse/wizard/decisiontable/template.xls").openStream();
        }
        catch (IOException iOException) {
            return null;
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }
}

