/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.view.rules;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.drools.eclipse.DRLInfo;
import org.drools.eclipse.DroolsEclipsePlugin;
import org.drools.eclipse.ProcessInfo;
import org.drools.eclipse.core.DroolsElement;
import org.drools.eclipse.core.DroolsModelBuilder;
import org.drools.eclipse.core.Function;
import org.drools.eclipse.core.Package;
import org.drools.eclipse.core.Process;
import org.drools.eclipse.core.RuleSet;
import org.drools.eclipse.core.ui.DroolsContentProvider;
import org.drools.eclipse.core.ui.DroolsLabelProvider;
import org.drools.eclipse.core.ui.DroolsTreeSorter;
import org.drools.eclipse.core.ui.FilterActionGroup;
import org.drools.lang.descr.FactTemplateDescr;
import org.drools.lang.descr.FunctionDescr;
import org.drools.lang.descr.GlobalDescr;
import org.drools.lang.descr.QueryDescr;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class RulesView
extends ViewPart
implements IDoubleClickListener,
IResourceVisitor,
IResourceChangeListener {
    private final RuleSet ruleSet = DroolsModelBuilder.createRuleSet();
    private Map resourcesMap = new HashMap();
    private TreeViewer treeViewer;

    public void createPartControl(Composite composite) {
        this.treeViewer = new TreeViewer(composite, 770);
        this.treeViewer.setContentProvider((IContentProvider)new DroolsContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new DroolsLabelProvider());
        this.treeViewer.setSorter((ViewerSorter)new DroolsTreeSorter());
        this.treeViewer.addDoubleClickListener((IDoubleClickListener)this);
        this.treeViewer.setUseHashlookup(true);
        this.treeViewer.setInput((Object)this.ruleSet);
        FilterActionGroup filterActionGroup = new FilterActionGroup((StructuredViewer)this.treeViewer, "org.drools.eclipse.view.rules.RulesView");
        filterActionGroup.fillActionBars(this.getViewSite().getActionBars());
    }

    public void init(IViewSite iViewSite, IMemento iMemento) throws PartInitException {
        super.init(iViewSite, iMemento);
        try {
            ResourcesPlugin.getWorkspace().getRoot().accept((IResourceVisitor)this);
        }
        catch (CoreException coreException) {
            DroolsEclipsePlugin.log(coreException);
        }
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
    }

    public void setFocus() {
        this.treeViewer.getControl().setFocus();
    }

    public boolean visit(IResource iResource) throws CoreException {
        return this.updateResource(iResource);
    }

    private boolean updateResource(IResource iResource) {
        IProject iProject = iResource.getProject();
        if (iProject != null) {
            IJavaProject iJavaProject = JavaCore.create((IProject)iProject);
            if (!iJavaProject.exists()) {
                return false;
            }
            if (iResource instanceof IFile && iJavaProject.isOnClasspath(iResource)) {
                IFile iFile = (IFile)iResource;
                if ("drl".equals(iResource.getFileExtension()) || "dslr".equals(iResource.getFileExtension())) {
                    Package package_;
                    DRLInfo dRLInfo;
                    block24: {
                        dRLInfo = DroolsEclipsePlugin.getDefault().parseResource(iResource, false);
                        String string = dRLInfo.getPackageName();
                        package_ = this.ruleSet.getPackage(string);
                        if (package_ == null) {
                            package_ = DroolsModelBuilder.addPackage(this.ruleSet, string, 0, 0);
                        }
                        if (dRLInfo.getBuilderErrors().length <= 0 && dRLInfo.getPackageDescr() != null) break block24;
                        return false;
                    }
                    try {
                        List<ArrayList<Object>> list;
                        List<Object> list2;
                        Object object;
                        Object object22;
                        List list3 = dRLInfo.getPackageDescr().getRules();
                        for (Object object22 : list3) {
                            boolean bl = object22 instanceof QueryDescr;
                            object = object22.getName();
                            if (!bl) {
                                list2 = DroolsModelBuilder.addRule(package_, (String)object, iFile, object22.getStartCharacter(), object22.getEndCharacter() - object22.getStartCharacter() + 1, null);
                                list = (List)this.resourcesMap.get(iFile);
                                if (list == null) {
                                    list = new ArrayList();
                                    this.resourcesMap.put(iFile, list);
                                }
                                list.add((ArrayList<Object>)list2);
                                continue;
                            }
                            list2 = DroolsModelBuilder.addQuery(package_, (String)object, iFile, object22.getStartCharacter(), object22.getEndCharacter() - object22.getStartCharacter() + 1);
                            list = (ArrayList<ArrayList<Object>>)this.resourcesMap.get(iFile);
                            if (list == null) {
                                list = new ArrayList<ArrayList<Object>>();
                                this.resourcesMap.put(iFile, list);
                            }
                            list.add((ArrayList<Object>)list2);
                        }
                        List list4 = dRLInfo.getPackageDescr().getFactTemplates();
                        object22 = list4.iterator();
                        while (object22.hasNext()) {
                            FactTemplateDescr factTemplateDescr = (FactTemplateDescr)object22.next();
                            object = DroolsModelBuilder.addTemplate(package_, factTemplateDescr.getName(), iFile, factTemplateDescr.getStartCharacter(), factTemplateDescr.getEndCharacter() - factTemplateDescr.getStartCharacter() + 1);
                            list2 = (List)this.resourcesMap.get(iFile);
                            if (list2 == null) {
                                list2 = new ArrayList<Object>();
                                this.resourcesMap.put(iFile, list2);
                            }
                            list2.add(object);
                        }
                        object22 = dRLInfo.getPackageDescr().getGlobals();
                        Object object3 = object22.iterator();
                        while (object3.hasNext()) {
                            object = (GlobalDescr)object3.next();
                            list2 = DroolsModelBuilder.addGlobal(package_, object.getIdentifier(), iFile, object.getStartCharacter(), object.getEndCharacter() - object.getStartCharacter() + 1);
                            list = (List)this.resourcesMap.get(iFile);
                            if (list == null) {
                                list = new ArrayList();
                                this.resourcesMap.put(iFile, list);
                            }
                            list.add((ArrayList<Object>)list2);
                        }
                        object3 = dRLInfo.getPackageDescr().getFunctions();
                        object = object3.iterator();
                        while (object.hasNext()) {
                            list2 = (FunctionDescr)object.next();
                            list = list2.getName();
                            Function function = DroolsModelBuilder.addFunction(package_, (String)((Object)list), iFile, list2.getStartCharacter(), list2.getEndCharacter() - list2.getStartCharacter() + 1);
                            ArrayList<Function> arrayList = (ArrayList<Function>)this.resourcesMap.get(iFile);
                            if (arrayList == null) {
                                arrayList = new ArrayList<Function>();
                                this.resourcesMap.put(iFile, arrayList);
                            }
                            arrayList.add(function);
                        }
                    }
                    catch (Throwable throwable) {
                        DroolsEclipsePlugin.log(throwable);
                    }
                    return false;
                }
                if ("rf".equals(iResource.getFileExtension())) {
                    try {
                        String string = RulesView.convertToString(iFile.getContents());
                        ProcessInfo processInfo = DroolsEclipsePlugin.getDefault().parseProcess(string, iResource);
                        if (processInfo != null && processInfo.getProcess() != null) {
                            String string2 = processInfo.getProcess().getPackageName();
                            Package package_ = this.ruleSet.getPackage(string2);
                            if (package_ == null) {
                                package_ = DroolsModelBuilder.addPackage(this.ruleSet, string2, 0, 0);
                            }
                            Process process = DroolsModelBuilder.addProcess(package_, processInfo.getProcess().getId(), iFile);
                            ArrayList<Process> arrayList = (ArrayList<Process>)this.resourcesMap.get(iFile);
                            if (arrayList == null) {
                                arrayList = new ArrayList<Process>();
                                this.resourcesMap.put(iFile, arrayList);
                            }
                            arrayList.add(process);
                        }
                    }
                    catch (Throwable throwable) {
                        DroolsEclipsePlugin.log(throwable);
                    }
                    return false;
                }
            }
        }
        return true;
    }

    public void resourceChanged(IResourceChangeEvent iResourceChangeEvent) {
        try {
            IResource iResource;
            if (iResourceChangeEvent.getType() == 1) {
                IResourceDelta iResourceDelta = iResourceChangeEvent.getDelta();
                if (iResourceDelta != null) {
                    iResourceDelta.accept(new IResourceDeltaVisitor(){

                        public boolean visit(IResourceDelta iResourceDelta) throws CoreException {
                            IResource iResource = iResourceDelta.getResource();
                            RulesView.this.removeElementsFromResource(iResource);
                            boolean bl = true;
                            if (iResourceDelta.getKind() != 2) {
                                bl = RulesView.this.updateResource(iResource);
                            }
                            RulesView.this.treeViewer.getControl().getDisplay().asyncExec(new Runnable(){

                                public void run() {
                                    if (!RulesView.this.treeViewer.getControl().isDisposed()) {
                                        RulesView.this.treeViewer.refresh();
                                    }
                                }
                            });
                            return bl;
                        }
                    });
                }
            } else if (iResourceChangeEvent.getType() == 4) {
                IResource iResource2 = iResourceChangeEvent.getResource();
                if (iResource2 != null) {
                    iResource2.accept(new IResourceVisitor(){

                        public boolean visit(IResource iResource) throws CoreException {
                            RulesView.this.removeElementsFromResource(iResource);
                            return true;
                        }
                    });
                }
            } else if (iResourceChangeEvent.getType() == 2 && (iResource = iResourceChangeEvent.getResource()) != null) {
                iResource.accept(new IResourceVisitor(){

                    public boolean visit(IResource iResource) throws CoreException {
                        RulesView.this.removeElementsFromResource(iResource);
                        return true;
                    }
                });
            }
        }
        catch (Throwable throwable) {
            DroolsEclipsePlugin.log(throwable);
        }
    }

    private void removeElementsFromResource(IResource iResource) {
        List list = (List)this.resourcesMap.get(iResource);
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                DroolsModelBuilder.removeElement((DroolsElement)iterator.next());
            }
            this.resourcesMap.remove(iResource);
        }
    }

    public void doubleClick(DoubleClickEvent doubleClickEvent) {
        DroolsElement droolsElement;
        IFile iFile;
        Object object;
        ISelection iSelection = doubleClickEvent.getSelection();
        if (iSelection instanceof IStructuredSelection && (object = ((StructuredSelection)iSelection).getFirstElement()) != null && object instanceof DroolsElement && (iFile = (droolsElement = (DroolsElement)object).getFile()) != null) {
            try {
                IEditorPart iEditorPart = IDE.openEditor((IWorkbenchPage)this.getSite().getPage(), (IFile)iFile);
                if (iEditorPart instanceof FormEditor) {
                    iEditorPart = ((FormEditor)iEditorPart).getActiveEditor();
                }
                if (iEditorPart instanceof ITextEditor) {
                    ((ITextEditor)iEditorPart).selectAndReveal(droolsElement.getOffset(), droolsElement.getLength());
                }
            }
            catch (Throwable throwable) {
                DroolsEclipsePlugin.log(throwable);
            }
        }
    }

    private static String convertToString(InputStream inputStream) throws IOException {
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = new char[1024];
        int n = 0;
        while ((n = inputStreamReader.read(cArray)) >= 0) {
            stringBuffer.append(cArray, 0, n);
        }
        return stringBuffer.toString();
    }
}

