/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.util;

import java.util.ArrayList;
import org.drools.eclipse.DroolsEclipsePlugin;
import org.drools.eclipse.util.DroolsRuntimeManager;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.core.ClasspathAccessRule;
import org.eclipse.jdt.internal.core.ClasspathEntry;

public class DroolsClasspathContainer
implements IClasspathContainer {
    IClasspathEntry[] droolsLibraryEntries;
    IPath path;
    IJavaProject javaProject = null;

    public DroolsClasspathContainer(IJavaProject iJavaProject, IPath iPath) {
        this.javaProject = iJavaProject;
        this.path = iPath;
    }

    public IClasspathEntry[] getClasspathEntries() {
        if (this.droolsLibraryEntries == null) {
            this.droolsLibraryEntries = this.createDroolsLibraryEntries(this.javaProject);
        }
        return this.droolsLibraryEntries;
    }

    public String getDescription() {
        return "Drools Library";
    }

    public int getKind() {
        return 1;
    }

    public IPath getPath() {
        return this.path;
    }

    private IClasspathEntry[] createDroolsLibraryEntries(IJavaProject iJavaProject) {
        int n = DroolsEclipsePlugin.getDefault().getPluginPreferences().getInt("Drools.InternalAPI");
        String[] stringArray = this.getJarNames(iJavaProject);
        ArrayList<IClasspathEntry> arrayList = new ArrayList<IClasspathEntry>();
        if (stringArray != null) {
            int n2 = 0;
            while (n2 < stringArray.length) {
                Path path = new Path(stringArray[n2]);
                if (n != 0) {
                    if (stringArray[n2].contains("drools-api")) {
                        arrayList.add(JavaCore.newLibraryEntry((IPath)path, (IPath)path, null));
                    } else {
                        IAccessRule[] iAccessRuleArray = new IAccessRule[]{new ClasspathAccessRule((IPath)new Path("**"), n)};
                        arrayList.add(JavaCore.newLibraryEntry((IPath)path, (IPath)path, null, (IAccessRule[])iAccessRuleArray, (IClasspathAttribute[])ClasspathEntry.NO_EXTRA_ATTRIBUTES, (boolean)false));
                    }
                }
                ++n2;
            }
        }
        return arrayList.toArray(new IClasspathEntry[arrayList.size()]);
    }

    private String[] getJarNames(IJavaProject iJavaProject) {
        return DroolsRuntimeManager.getDroolsRuntimeJars(iJavaProject.getProject());
    }
}

