/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.rulebuilder.wizards;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.drools.eclipse.DroolsEclipsePlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.ide.IDE;

public class NewBrlFileWizardPage
extends WizardNewFileCreationPage {
    private static final String BRL_EXTENSION = ".brl";
    private IWorkbench workbench;

    public NewBrlFileWizardPage(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
        super("createGuidedRuleFilePage", iStructuredSelection);
        this.setTitle("RuleBuilder Editor File");
        this.setDescription("This wizard creates a new file with *.brl extension that can be opened by a multi-page editor.");
        this.workbench = iWorkbench;
    }

    public void createControl(Composite composite) {
        super.createControl(composite);
        this.setPageComplete(true);
    }

    public boolean finish() {
        IFile iFile;
        String string = this.getFileName();
        if (!string.endsWith(BRL_EXTENSION)) {
            this.setFileName(String.valueOf(string) + BRL_EXTENSION);
        }
        if ((iFile = this.createNewFile()) == null) {
            return false;
        }
        try {
            IWorkbenchWindow iWorkbenchWindow = this.workbench.getActiveWorkbenchWindow();
            IWorkbenchPage iWorkbenchPage = iWorkbenchWindow.getActivePage();
            if (iWorkbenchPage != null) {
                IDE.openEditor((IWorkbenchPage)iWorkbenchPage, (IFile)iFile, (boolean)true);
            }
        }
        catch (PartInitException partInitException) {
            DroolsEclipsePlugin.log(partInitException);
            return false;
        }
        return true;
    }

    protected InputStream getInitialContents() {
        String string = "";
        return new ByteArrayInputStream(string.getBytes());
    }
}

