/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.rulebuilder.ui;

import java.util.ArrayList;
import org.drools.eclipse.rulebuilder.modeldriven.HumanReadable;
import org.drools.eclipse.rulebuilder.ui.AddCompositeConstraintOptionDialog;
import org.drools.eclipse.rulebuilder.ui.AddNewFieldConstraintDialog;
import org.drools.eclipse.rulebuilder.ui.AssignFieldVariableDialog;
import org.drools.eclipse.rulebuilder.ui.ConstraintValueEditor;
import org.drools.eclipse.rulebuilder.ui.RuleModeller;
import org.drools.eclipse.rulebuilder.ui.Widget;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.client.modeldriven.brl.BaseSingleFieldConstraint;
import org.drools.ide.common.client.modeldriven.brl.CompositeFactPattern;
import org.drools.ide.common.client.modeldriven.brl.CompositeFieldConstraint;
import org.drools.ide.common.client.modeldriven.brl.ConnectiveConstraint;
import org.drools.ide.common.client.modeldriven.brl.FactPattern;
import org.drools.ide.common.client.modeldriven.brl.FieldConstraint;
import org.drools.ide.common.client.modeldriven.brl.SingleFieldConstraint;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;

public class FactPatternWidget
extends Widget {
    private final CompositeFactPattern parentPattern;
    private final FactPattern pattern;
    private boolean bindable;

    public FactPatternWidget(FormToolkit formToolkit, Composite composite, RuleModeller ruleModeller, FactPattern factPattern, CompositeFactPattern compositeFactPattern, int n, boolean bl) {
        super(composite, formToolkit, ruleModeller, n);
        this.pattern = factPattern;
        this.parentPattern = compositeFactPattern;
        this.bindable = bl;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        gridLayout.marginBottom = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginLeft = 0;
        gridLayout.marginRight = 0;
        gridLayout.marginTop = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 0;
        composite.setLayout((Layout)gridLayout);
        this.create();
    }

    private void create() {
        Composite composite = new Composite(this.parent, 524288);
        composite.setLayout((Layout)new GridLayout(1, true));
        Label label = this.toolkit.createLabel(composite, this.getPatternLabel());
        label.setBackground(Display.getDefault().getSystemColor(15));
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        gridData.verticalAlignment = 0x1000000;
        composite.setLayoutData((Object)gridData);
        composite.setBackground(Display.getDefault().getSystemColor(15));
        this.addDeleteAction();
        this.addMoreOptionsAction();
        Composite composite2 = this.toolkit.createComposite(this.parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 8;
        gridLayout.marginLeft = 5;
        composite2.setLayout((Layout)gridLayout);
        int n = 0;
        while (n < this.pattern.getFieldConstraints().length) {
            FieldConstraint fieldConstraint = this.pattern.getFieldConstraints()[n];
            if (fieldConstraint instanceof SingleFieldConstraint) {
                boolean bl = ((SingleFieldConstraint)fieldConstraint).getParent() != null;
            }
            this.renderFieldConstraints(composite2, fieldConstraint, null, n, true, false);
            ++n;
        }
        this.toolkit.paintBordersFor(composite2);
    }

    private void addMoreOptionsAction() {
        ImageHyperlink imageHyperlink = this.addImage(this.parent, "icons/new_item.gif");
        imageHyperlink.addHyperlinkListener(new IHyperlinkListener(){

            public void linkActivated(HyperlinkEvent hyperlinkEvent) {
                AddNewFieldConstraintDialog addNewFieldConstraintDialog = new AddNewFieldConstraintDialog(FactPatternWidget.this.parent.getShell(), FactPatternWidget.this.toolkit, FactPatternWidget.this.getModeller(), FactPatternWidget.this.pattern, FactPatternWidget.this.parentPattern != null);
                addNewFieldConstraintDialog.open();
            }

            public void linkEntered(HyperlinkEvent hyperlinkEvent) {
            }

            public void linkExited(HyperlinkEvent hyperlinkEvent) {
            }
        });
        imageHyperlink.setToolTipText("Add a field to this condition, or bind a varible to this fact.");
    }

    private void addDeleteAction() {
        ImageHyperlink imageHyperlink = this.addImage(this.parent, "icons/delete_obj.gif");
        imageHyperlink.addHyperlinkListener(new IHyperlinkListener(){

            public void linkActivated(HyperlinkEvent hyperlinkEvent) {
                MessageBox messageBox = new MessageBox(Display.getCurrent().getActiveShell(), 200);
                messageBox.setMessage("Remove this ENTIRE condition, and all the field constraints that belong to it.");
                messageBox.setText("Remove this entire condition?");
                if (messageBox.open() == 64) {
                    if (FactPatternWidget.this.parentPattern == null) {
                        if (FactPatternWidget.this.getModeller().getModel().removeLhsItem(FactPatternWidget.this.index)) {
                            FactPatternWidget.this.getModeller().reloadLhs();
                        } else {
                            FactPatternWidget.this.showMessage("Can't remove that item as it is used in the action part of the rule.");
                        }
                    } else {
                        FactPatternWidget.this.deleteBindedFact();
                    }
                    FactPatternWidget.this.getModeller().setDirty(true);
                }
            }

            public void linkEntered(HyperlinkEvent hyperlinkEvent) {
            }

            public void linkExited(HyperlinkEvent hyperlinkEvent) {
            }
        });
        imageHyperlink.setToolTipText("Remove this condition.");
    }

    private void renderFieldConstraints(Composite composite, FieldConstraint fieldConstraint, CompositeFieldConstraint compositeFieldConstraint, int n, boolean bl, boolean bl2) {
        if (fieldConstraint instanceof SingleFieldConstraint) {
            this.renderSingleFieldConstraint(composite, n, fieldConstraint, compositeFieldConstraint, bl, bl2);
        } else if (fieldConstraint instanceof CompositeFieldConstraint) {
            this.compositeFieldConstraintEditor(composite, (CompositeFieldConstraint)fieldConstraint, compositeFieldConstraint, n, bl2);
        }
    }

    private void compositeFieldConstraintEditor(Composite composite, final CompositeFieldConstraint compositeFieldConstraint, CompositeFieldConstraint compositeFieldConstraint2, int n, boolean bl) {
        if (compositeFieldConstraint.compositeJunctionType.equals("&&")) {
            this.toolkit.createLabel(composite, "All of:");
        } else {
            this.toolkit.createLabel(composite, "Any of:");
        }
        this.addRemoveButton(composite, compositeFieldConstraint2, n, "icons/delete_obj.gif", bl);
        ImageHyperlink imageHyperlink = this.addImage(composite, "icons/new_item.gif");
        imageHyperlink.addHyperlinkListener(new IHyperlinkListener(){

            public void linkActivated(HyperlinkEvent hyperlinkEvent) {
                AddCompositeConstraintOptionDialog addCompositeConstraintOptionDialog = new AddCompositeConstraintOptionDialog(FactPatternWidget.this.parent.getShell(), FactPatternWidget.this.getModeller(), compositeFieldConstraint, FactPatternWidget.this.pattern);
                addCompositeConstraintOptionDialog.open();
            }

            public void linkEntered(HyperlinkEvent hyperlinkEvent) {
            }

            public void linkExited(HyperlinkEvent hyperlinkEvent) {
            }
        });
        imageHyperlink.setToolTipText("Add fields to this constriant.");
        this.addNestedElements(composite, compositeFieldConstraint);
    }

    private void addNestedElements(Composite composite, CompositeFieldConstraint compositeFieldConstraint) {
        FieldConstraint[] fieldConstraintArray = compositeFieldConstraint.constraints;
        if (fieldConstraintArray != null) {
            Composite composite2 = this.toolkit.createComposite(composite);
            GridData gridData = new GridData(768);
            gridData.horizontalSpan = 5;
            composite2.setLayoutData((Object)gridData);
            GridLayout gridLayout = new GridLayout();
            gridLayout.numColumns = 8;
            gridLayout.marginBottom = 0;
            gridLayout.marginHeight = 0;
            gridLayout.marginLeft = 0;
            gridLayout.marginRight = 0;
            gridLayout.marginTop = 0;
            gridLayout.marginWidth = 0;
            gridLayout.verticalSpacing = 0;
            composite2.setLayout((Layout)gridLayout);
            int n = 0;
            while (n < fieldConstraintArray.length) {
                this.renderFieldConstraints(composite2, fieldConstraintArray[n], compositeFieldConstraint, n, false, true);
                this.toolkit.paintBordersFor(composite2);
                ++n;
            }
        } else {
            GridData gridData = new GridData(768);
            gridData.horizontalSpan = 5;
            Label label = this.toolkit.createLabel(composite, "");
            label.setLayoutData((Object)gridData);
        }
    }

    private void renderSingleFieldConstraint(Composite composite, int n, FieldConstraint fieldConstraint, CompositeFieldConstraint compositeFieldConstraint, boolean bl, boolean bl2) {
        SingleFieldConstraint singleFieldConstraint = (SingleFieldConstraint)fieldConstraint;
        if (singleFieldConstraint.getConstraintValueType() != 5) {
            this.createConstraintRow(composite, compositeFieldConstraint, n, singleFieldConstraint, bl, bl2);
        } else {
            this.createPredicateConstraintRow(composite, n, singleFieldConstraint);
        }
    }

    private void createConstraintRow(Composite composite, CompositeFieldConstraint compositeFieldConstraint, int n, SingleFieldConstraint singleFieldConstraint, boolean bl, boolean bl2) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(2, false));
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 16384;
        gridData.horizontalSpan = 2;
        composite2.setLayoutData((Object)gridData);
        GridData gridData2 = new GridData();
        gridData2.horizontalIndent = 15 * this.getNests(singleFieldConstraint);
        this.addBindingField(composite2, singleFieldConstraint, bl, gridData2);
        this.toolkit.createLabel(composite2, singleFieldConstraint.getFieldName());
        if (!(this.hasChildren(n) || singleFieldConstraint.connectives != null && singleFieldConstraint.connectives.length != 0)) {
            this.addRemoveButton(composite, compositeFieldConstraint, n, "icons/delete_item_small.gif", bl2);
        } else {
            this.toolkit.createLabel(composite, "");
        }
        this.operatorDropDown(composite, singleFieldConstraint);
        this.constraintValueEditor(composite, (BaseSingleFieldConstraint)singleFieldConstraint, singleFieldConstraint.getFieldName());
        this.createConnectives(composite, singleFieldConstraint);
        this.addConnectiveAction(composite, singleFieldConstraint);
    }

    private int getNests(SingleFieldConstraint singleFieldConstraint) {
        SingleFieldConstraint singleFieldConstraint2 = (SingleFieldConstraint)singleFieldConstraint.getParent();
        int n = 0;
        while (singleFieldConstraint2 != null) {
            ++n;
            singleFieldConstraint2 = (SingleFieldConstraint)singleFieldConstraint2.getParent();
        }
        return n;
    }

    private void addBindingField(Composite composite, final SingleFieldConstraint singleFieldConstraint, boolean bl, Object object) {
        if (!singleFieldConstraint.isBound()) {
            if (this.bindable && bl) {
                ImageHyperlink imageHyperlink = this.addImage(composite, "icons/new_item.gif");
                imageHyperlink.addHyperlinkListener(new IHyperlinkListener(){

                    public void linkActivated(HyperlinkEvent hyperlinkEvent) {
                        AssignFieldVariableDialog assignFieldVariableDialog = new AssignFieldVariableDialog(FactPatternWidget.this.parent.getShell(), FactPatternWidget.this.toolkit, FactPatternWidget.this.getModeller(), singleFieldConstraint, FactPatternWidget.this.pattern);
                        assignFieldVariableDialog.open();
                    }

                    public void linkEntered(HyperlinkEvent hyperlinkEvent) {
                    }

                    public void linkExited(HyperlinkEvent hyperlinkEvent) {
                    }
                });
                imageHyperlink.setToolTipText("Bind the field called [" + singleFieldConstraint.getFieldName() + "] to a variable.");
                imageHyperlink.setLayoutData(object);
            } else {
                this.toolkit.createLabel(composite, "");
            }
        } else {
            this.toolkit.createLabel(composite, "[" + singleFieldConstraint.getFieldBinding() + "]");
        }
    }

    private void createPredicateConstraintRow(Composite composite, int n, SingleFieldConstraint singleFieldConstraint) {
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 6;
        this.addImage(composite, "icons/function_assets.gif");
        this.formulaValueEditor(composite, (BaseSingleFieldConstraint)singleFieldConstraint, gridData);
        this.addRemoveButton(composite, null, n, "icons/delete_item_small.gif", false);
    }

    private void createConnectives(Composite composite, SingleFieldConstraint singleFieldConstraint) {
        if (singleFieldConstraint.connectives != null && singleFieldConstraint.connectives.length > 0) {
            int n = 0;
            while (n < singleFieldConstraint.connectives.length) {
                this.toolkit.createLabel(composite, "");
                this.toolkit.createLabel(composite, "");
                this.toolkit.createLabel(composite, "");
                ConnectiveConstraint connectiveConstraint = singleFieldConstraint.connectives[n];
                this.addRemoveConstraintAction(composite, singleFieldConstraint, connectiveConstraint);
                this.connectiveOperatorDropDown(composite, connectiveConstraint, singleFieldConstraint.getFieldName());
                this.constraintValueEditor(composite, (BaseSingleFieldConstraint)connectiveConstraint, singleFieldConstraint.getFieldName());
                ++n;
            }
        }
    }

    private void constraintValueEditor(Composite composite, BaseSingleFieldConstraint baseSingleFieldConstraint, String string) {
        String string2 = this.modeller.getSuggestionCompletionEngine().getFieldType(this.pattern.factType, string);
        new ConstraintValueEditor(composite, baseSingleFieldConstraint, this.toolkit, this.modeller, string2, this.pattern);
    }

    private void addConnectiveAction(Composite composite, final SingleFieldConstraint singleFieldConstraint) {
        ImageHyperlink imageHyperlink = this.addImage(composite, "icons/add_connective.gif");
        imageHyperlink.setToolTipText("Add more options to this fields values.");
        imageHyperlink.addHyperlinkListener(new IHyperlinkListener(){

            public void linkActivated(HyperlinkEvent hyperlinkEvent) {
                singleFieldConstraint.addNewConnective();
                FactPatternWidget.this.getModeller().reloadLhs();
                FactPatternWidget.this.getModeller().setDirty(true);
            }

            public void linkEntered(HyperlinkEvent hyperlinkEvent) {
            }

            public void linkExited(HyperlinkEvent hyperlinkEvent) {
            }
        });
        imageHyperlink.setLayoutData((Object)new GridData(800));
    }

    private void addRemoveButton(Composite composite, CompositeFieldConstraint compositeFieldConstraint, int n, String string, boolean bl) {
        if (bl) {
            this.addNestedConstraintDeleteAction(composite, compositeFieldConstraint, n, string);
        } else {
            this.addRemoveFieldAction(composite, n, string);
        }
    }

    private void addNestedConstraintDeleteAction(Composite composite, final CompositeFieldConstraint compositeFieldConstraint, final int n, String string) {
        ImageHyperlink imageHyperlink = this.addImage(composite, string);
        imageHyperlink.addHyperlinkListener(new IHyperlinkListener(){

            public void linkActivated(HyperlinkEvent hyperlinkEvent) {
                MessageBox messageBox = new MessageBox(Display.getCurrent().getActiveShell(), 200);
                messageBox.setMessage("Remove this (nested) restriction.");
                messageBox.setText("Remove this item from nested constraint?");
                if (messageBox.open() == 64) {
                    compositeFieldConstraint.removeConstraint(n);
                    FactPatternWidget.this.getModeller().reloadLhs();
                    FactPatternWidget.this.getModeller().setDirty(true);
                }
            }

            public void linkEntered(HyperlinkEvent hyperlinkEvent) {
            }

            public void linkExited(HyperlinkEvent hyperlinkEvent) {
            }
        });
    }

    private void addRemoveFieldAction(Composite composite, final int n, String string) {
        ImageHyperlink imageHyperlink = this.addImage(composite, string);
        imageHyperlink.setToolTipText("Remove this fieldconstraint");
        imageHyperlink.addHyperlinkListener(new IHyperlinkListener(){

            public void linkActivated(HyperlinkEvent hyperlinkEvent) {
                MessageBox messageBox = new MessageBox(Display.getCurrent().getActiveShell(), 200);
                messageBox.setMessage("Remove this item?");
                messageBox.setText("Remove this item?");
                if (messageBox.open() == 64) {
                    FactPatternWidget.this.pattern.removeConstraint(n);
                    FactPatternWidget.this.getModeller().reloadLhs();
                    FactPatternWidget.this.getModeller().setDirty(true);
                }
            }

            public void linkEntered(HyperlinkEvent hyperlinkEvent) {
            }

            public void linkExited(HyperlinkEvent hyperlinkEvent) {
            }
        });
        imageHyperlink.setLayoutData((Object)new GridData(800));
    }

    private boolean hasChildren(int n) {
        SingleFieldConstraint singleFieldConstraint = (SingleFieldConstraint)this.pattern.getFieldConstraints()[n];
        FieldConstraint[] fieldConstraintArray = this.pattern.getFieldConstraints();
        int n2 = n;
        while (n2 < fieldConstraintArray.length) {
            SingleFieldConstraint singleFieldConstraint2 = (SingleFieldConstraint)fieldConstraintArray[n2];
            if (singleFieldConstraint.equals(singleFieldConstraint2.getParent())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void addRemoveConstraintAction(Composite composite, final SingleFieldConstraint singleFieldConstraint, final ConnectiveConstraint connectiveConstraint) {
        ImageHyperlink imageHyperlink = this.addImage(composite, "icons/delete_item_small.gif");
        imageHyperlink.setToolTipText("Remove this field constraint");
        imageHyperlink.addHyperlinkListener(new IHyperlinkListener(){

            public void linkActivated(HyperlinkEvent hyperlinkEvent) {
                MessageBox messageBox = new MessageBox(Display.getCurrent().getActiveShell(), 200);
                messageBox.setMessage("Remove this item?");
                messageBox.setText("Remove this item?");
                if (messageBox.open() == 64) {
                    ConnectiveConstraint[] connectiveConstraintArray = singleFieldConstraint.connectives;
                    ArrayList<ConnectiveConstraint> arrayList = new ArrayList<ConnectiveConstraint>();
                    int n = 0;
                    while (n < connectiveConstraintArray.length) {
                        if (connectiveConstraintArray[n] != connectiveConstraint) {
                            arrayList.add(connectiveConstraintArray[n]);
                        }
                        ++n;
                    }
                    singleFieldConstraint.connectives = arrayList.toArray(new ConnectiveConstraint[arrayList.size()]);
                    FactPatternWidget.this.getModeller().reloadLhs();
                    FactPatternWidget.this.getModeller().setDirty(true);
                }
            }

            public void linkEntered(HyperlinkEvent hyperlinkEvent) {
            }

            public void linkExited(HyperlinkEvent hyperlinkEvent) {
            }
        });
        imageHyperlink.setLayoutData((Object)new GridData(896));
    }

    private String getPatternLabel() {
        if (this.pattern.boundName != null) {
            return String.valueOf(this.pattern.factType) + " [" + this.pattern.boundName + "]";
        }
        return this.pattern.factType;
    }

    private void operatorDropDown(Composite composite, final SingleFieldConstraint singleFieldConstraint) {
        String[] stringArray = this.getCompletions().getOperatorCompletions(this.pattern.factType, singleFieldConstraint.getFieldName());
        final Combo combo = new Combo(composite, 76);
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            combo.add(HumanReadable.getOperatorDisplayName(string));
            if (string.equals(singleFieldConstraint.getOperator())) {
                combo.select(n);
            }
            ++n;
        }
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        combo.setLayoutData((Object)gridData);
        combo.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                singleFieldConstraint.setOperator(HumanReadable.getOperatorName(combo.getText()));
                FactPatternWidget.this.getModeller().setDirty(true);
            }
        });
    }

    private void connectiveOperatorDropDown(Composite composite, final ConnectiveConstraint connectiveConstraint, String string) {
        String[] stringArray = this.getCompletions().getConnectiveOperatorCompletions(this.pattern.factType, string);
        final Combo combo = new Combo(composite, 76);
        int n = 0;
        while (n < stringArray.length) {
            String string2 = stringArray[n];
            combo.add(HumanReadable.getOperatorDisplayName(string2));
            if (string2.equals(connectiveConstraint.operator)) {
                combo.select(n);
            }
            ++n;
        }
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        combo.setLayoutData((Object)gridData);
        combo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                connectiveConstraint.operator = HumanReadable.getOperatorName(combo.getText());
                FactPatternWidget.this.getModeller().setDirty(true);
            }
        });
    }

    private void formulaValueEditor(Composite composite, final BaseSingleFieldConstraint baseSingleFieldConstraint, GridData gridData) {
        final Text text = this.toolkit.createText(composite, "");
        if (baseSingleFieldConstraint.getValue() != null) {
            text.setText(baseSingleFieldConstraint.getValue());
        }
        gridData.grabExcessHorizontalSpace = true;
        gridData.minimumWidth = 100;
        text.setLayoutData((Object)gridData);
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                baseSingleFieldConstraint.setValue(text.getText());
                FactPatternWidget.this.getModeller().setDirty(true);
            }
        });
    }

    private void deleteBindedFact() {
        ArrayList<FactPattern> arrayList = new ArrayList<FactPattern>();
        int n = 0;
        while (n < this.parentPattern.patterns.length) {
            if (this.parentPattern.patterns[n] != this.pattern) {
                arrayList.add(this.parentPattern.patterns[n]);
            }
            ++n;
        }
        this.parentPattern.patterns = arrayList.toArray(new FactPattern[arrayList.size()]);
        this.getModeller().reloadLhs();
    }

    private SuggestionCompletionEngine getCompletions() {
        return this.getModeller().getSuggestionCompletionEngine();
    }
}

