/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.rulebuilder.ui;

import java.util.List;
import org.drools.eclipse.DroolsEclipsePlugin;
import org.drools.eclipse.rulebuilder.ui.RuleModeller;
import org.drools.eclipse.rulebuilder.ui.ValueEditorTypeSelectionDialog;
import org.drools.ide.common.client.modeldriven.DropDownData;
import org.drools.ide.common.client.modeldriven.brl.BaseSingleFieldConstraint;
import org.drools.ide.common.client.modeldriven.brl.ConnectiveConstraint;
import org.drools.ide.common.client.modeldriven.brl.FactPattern;
import org.drools.ide.common.client.modeldriven.brl.SingleFieldConstraint;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;

public class ConstraintValueEditor {
    private Composite composite;
    private BaseSingleFieldConstraint constraint;
    private FormToolkit toolkit;
    private RuleModeller modeller;
    private boolean numericValue;
    private FactPattern pattern;

    public ConstraintValueEditor(Composite composite, BaseSingleFieldConstraint baseSingleFieldConstraint, FormToolkit formToolkit, RuleModeller ruleModeller, String string) {
        this(composite, baseSingleFieldConstraint, formToolkit, ruleModeller, string, null);
    }

    public ConstraintValueEditor(Composite composite, BaseSingleFieldConstraint baseSingleFieldConstraint, FormToolkit formToolkit, RuleModeller ruleModeller, String string, FactPattern factPattern) {
        this.pattern = factPattern;
        this.composite = composite;
        this.constraint = baseSingleFieldConstraint;
        this.toolkit = formToolkit;
        this.modeller = ruleModeller;
        if ("Numeric".equals(string)) {
            this.numericValue = true;
        }
        this.create();
    }

    private void create() {
        if (this.constraint.getConstraintValueType() == 0) {
            ImageHyperlink imageHyperlink = this.addImage(this.composite, "icons/edit.gif");
            imageHyperlink.setToolTipText("Choose value editor type");
            imageHyperlink.addHyperlinkListener(new IHyperlinkListener(){

                public void linkActivated(HyperlinkEvent hyperlinkEvent) {
                    ValueEditorTypeSelectionDialog valueEditorTypeSelectionDialog = new ValueEditorTypeSelectionDialog(ConstraintValueEditor.this.composite.getShell(), ConstraintValueEditor.this.toolkit, ConstraintValueEditor.this.modeller, ConstraintValueEditor.this.constraint);
                    valueEditorTypeSelectionDialog.open();
                }

                public void linkEntered(HyperlinkEvent hyperlinkEvent) {
                }

                public void linkExited(HyperlinkEvent hyperlinkEvent) {
                }
            });
            GridData gridData = new GridData(800);
            gridData.horizontalSpan = 2;
            imageHyperlink.setLayoutData((Object)gridData);
        } else {
            switch (this.constraint.getConstraintValueType()) {
                case 1: {
                    this.literalValueEditor(this.composite, this.constraint, new GridData(768));
                    break;
                }
                case 3: {
                    this.addImage(this.composite, "icons/function_assets.gif");
                    this.formulaValueEditor(this.composite, this.constraint, new GridData(768));
                    break;
                }
                case 2: {
                    this.variableEditor(this.composite, this.constraint, new GridData(768));
                    break;
                }
            }
        }
    }

    private void literalValueEditor(Composite composite, final BaseSingleFieldConstraint baseSingleFieldConstraint, GridData gridData) {
        String string = null;
        if (baseSingleFieldConstraint instanceof SingleFieldConstraint) {
            string = ((SingleFieldConstraint)baseSingleFieldConstraint).getFieldName();
        } else if (baseSingleFieldConstraint instanceof ConnectiveConstraint) {
            string = ((ConnectiveConstraint)baseSingleFieldConstraint).fieldName;
        }
        String string2 = null;
        if (baseSingleFieldConstraint instanceof SingleFieldConstraint) {
            string2 = ((SingleFieldConstraint)baseSingleFieldConstraint).getFieldType();
        } else if (baseSingleFieldConstraint instanceof ConnectiveConstraint) {
            string2 = ((ConnectiveConstraint)baseSingleFieldConstraint).fieldType;
        }
        DropDownData dropDownData = null;
        boolean bl = false;
        dropDownData = string2.equals("Boolean") ? DropDownData.create((String[])new String[]{"true", "false"}) : this.modeller.getSuggestionCompletionEngine().getEnums(this.pattern, string);
        if (dropDownData != null && dropDownData.fixedList.length > 0) {
            String[] stringArray = dropDownData.fixedList;
            final Combo combo = new Combo(composite, 12);
            int n = 0;
            while (n < stringArray.length) {
                String string3 = stringArray[n];
                String[] stringArray2 = null;
                boolean bl2 = false;
                if (string3.indexOf(61) > 0) {
                    stringArray2 = string3.split("=");
                    string3 = stringArray2[1];
                    combo.add(string3.trim());
                    combo.setData(string3.trim(), (Object)stringArray2[0].trim());
                    bl2 = true;
                } else {
                    combo.add(string3);
                }
                if (string3.equals(baseSingleFieldConstraint.getValue()) || bl2 && stringArray2[0].trim().equals(baseSingleFieldConstraint.getValue())) {
                    combo.select(n);
                    bl = true;
                }
                ++n;
            }
            if (!bl && baseSingleFieldConstraint.getValue() != null) {
                combo.add(baseSingleFieldConstraint.getValue());
                combo.select(combo.getItemCount() - 1);
            }
            combo.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent modifyEvent) {
                    String string = combo.getItem(combo.getSelectionIndex());
                    if (combo.getData(string) != null) {
                        string = (String)combo.getData(string);
                    }
                    baseSingleFieldConstraint.setValue(string);
                    ConstraintValueEditor.this.modeller.reloadLhs();
                    ConstraintValueEditor.this.modeller.setDirty(true);
                }
            });
            gridData.horizontalSpan = 2;
            gridData.grabExcessHorizontalSpace = true;
            gridData.minimumWidth = 100;
            combo.setLayoutData((Object)gridData);
        } else {
            final Text text = this.toolkit.createText(composite, "");
            if (baseSingleFieldConstraint.getValue() != null) {
                text.setText(baseSingleFieldConstraint.getValue());
            }
            gridData.horizontalSpan = 2;
            gridData.grabExcessHorizontalSpace = true;
            gridData.minimumWidth = 100;
            text.setLayoutData((Object)gridData);
            text.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent modifyEvent) {
                    baseSingleFieldConstraint.setValue(text.getText());
                    ConstraintValueEditor.this.modeller.setDirty(true);
                }
            });
            if (this.numericValue) {
                text.addKeyListener(new KeyListener(){

                    public void keyPressed(KeyEvent keyEvent) {
                        if (Character.isLetter(keyEvent.character)) {
                            keyEvent.doit = false;
                        }
                    }

                    public void keyReleased(KeyEvent keyEvent) {
                    }
                });
            }
        }
    }

    private void formulaValueEditor(Composite composite, final BaseSingleFieldConstraint baseSingleFieldConstraint, GridData gridData) {
        final Text text = this.toolkit.createText(composite, "");
        if (baseSingleFieldConstraint.getValue() != null) {
            text.setText(baseSingleFieldConstraint.getValue());
        }
        gridData.grabExcessHorizontalSpace = true;
        gridData.minimumWidth = 100;
        text.setLayoutData((Object)gridData);
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                baseSingleFieldConstraint.setValue(text.getText());
                ConstraintValueEditor.this.modeller.setDirty(true);
            }
        });
    }

    private void variableEditor(Composite composite, final BaseSingleFieldConstraint baseSingleFieldConstraint, GridData gridData) {
        List list = this.modeller.getModel().getBoundVariablesInScope(baseSingleFieldConstraint);
        final Combo combo = new Combo(composite, 8);
        gridData.horizontalSpan = 2;
        combo.setLayoutData((Object)gridData);
        if (baseSingleFieldConstraint.getValue() == null) {
            combo.add("Choose ...");
        }
        int n = 0;
        int n2 = 0;
        while (n2 < list.size()) {
            String string = (String)list.get(n2);
            if (baseSingleFieldConstraint.getValue() != null && baseSingleFieldConstraint.getValue().equals(string)) {
                n = n2;
            }
            combo.add(string);
            ++n2;
        }
        combo.select(n);
        combo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                baseSingleFieldConstraint.setValue(combo.getText());
            }
        });
    }

    public ImageHyperlink addImage(Composite composite, String string) {
        ImageHyperlink imageHyperlink = this.toolkit.createImageHyperlink(composite, 0);
        ImageDescriptor imageDescriptor = DroolsEclipsePlugin.getImageDescriptor(string);
        imageHyperlink.setImage(imageDescriptor.createImage());
        return imageHyperlink;
    }
}

