/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.rulebuilder.ui;

import org.drools.eclipse.rulebuilder.ui.RuleDialog;
import org.drools.eclipse.rulebuilder.ui.RuleModeller;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.client.modeldriven.brl.CompositeFieldConstraint;
import org.drools.ide.common.client.modeldriven.brl.FactPattern;
import org.drools.ide.common.client.modeldriven.brl.FieldConstraint;
import org.drools.ide.common.client.modeldriven.brl.SingleFieldConstraint;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class AddNewFieldConstraintDialog
extends RuleDialog {
    private final FormToolkit toolkit;
    private RuleModeller modeller;
    private FactPattern pattern;
    private boolean isNested;

    public AddNewFieldConstraintDialog(Shell shell, FormToolkit formToolkit, RuleModeller ruleModeller, FactPattern factPattern, boolean bl) {
        super(shell, "Update constraints", "Pick the values from combos and confirm the selection.");
        this.toolkit = formToolkit;
        this.modeller = ruleModeller;
        this.pattern = factPattern;
        this.isNested = bl;
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.marginBottom = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginLeft = 0;
        gridLayout.marginRight = 0;
        gridLayout.marginTop = 0;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.createFieldRestrictionCombo(composite2, gridData);
        this.createMultipleRestrictionCombo(composite2, gridData);
        this.createFormulaRow(composite2, gridData);
        if (!this.isNested) {
            this.createVariableBindingRow(composite2);
        }
        this.toolkit.paintBordersFor(composite2);
        return composite2;
    }

    private void createMultipleRestrictionCombo(Composite composite, GridData gridData) {
        this.createLabel(composite, "Multiple field constriant");
        final Combo combo = new Combo(composite, 8);
        combo.setLayoutData((Object)gridData);
        combo.add("...");
        combo.add("All of (And)");
        combo.add("Any of (Or)");
        combo.setData("All of (And)", (Object)"&&");
        combo.setData("Any of (Or)", (Object)"||");
        combo.select(0);
        combo.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (combo.getSelectionIndex() == 0) {
                    return;
                }
                CompositeFieldConstraint compositeFieldConstraint = new CompositeFieldConstraint();
                compositeFieldConstraint.compositeJunctionType = (String)combo.getData(combo.getText());
                AddNewFieldConstraintDialog.this.pattern.addConstraint((FieldConstraint)compositeFieldConstraint);
                AddNewFieldConstraintDialog.this.modeller.reloadLhs();
                AddNewFieldConstraintDialog.this.modeller.setDirty(true);
                AddNewFieldConstraintDialog.this.close();
            }
        });
    }

    private void createFieldRestrictionCombo(Composite composite, GridData gridData) {
        this.createLabel(composite, "Add a restriction on a field");
        SuggestionCompletionEngine suggestionCompletionEngine = this.getCompletion();
        String[] stringArray = suggestionCompletionEngine.getFieldCompletions(this.pattern.factType);
        final Combo combo = new Combo(composite, 8);
        combo.setLayoutData((Object)gridData);
        combo.add("...");
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            combo.add(string);
            combo.setData(string, (Object)suggestionCompletionEngine.getFieldType(String.valueOf(this.pattern.factType) + "." + string));
            ++n;
        }
        combo.select(0);
        combo.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (combo.getSelectionIndex() == 0) {
                    return;
                }
                SingleFieldConstraint singleFieldConstraint = new SingleFieldConstraint();
                singleFieldConstraint.setFieldName(combo.getText());
                singleFieldConstraint.setFieldType((String)combo.getData(combo.getText()));
                AddNewFieldConstraintDialog.this.pattern.addConstraint((FieldConstraint)singleFieldConstraint);
                AddNewFieldConstraintDialog.this.modeller.setDirty(true);
                AddNewFieldConstraintDialog.this.modeller.reloadLhs();
                AddNewFieldConstraintDialog.this.close();
            }
        });
    }

    private void createFormulaRow(Composite composite, GridData gridData) {
        this.createLabel(composite, "Add a new formula style expression");
        Button button = this.toolkit.createButton(composite, "New formula", 8);
        button.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                SingleFieldConstraint singleFieldConstraint = new SingleFieldConstraint();
                singleFieldConstraint.setConstraintValueType(5);
                AddNewFieldConstraintDialog.this.pattern.addConstraint((FieldConstraint)singleFieldConstraint);
                AddNewFieldConstraintDialog.this.modeller.setDirty(true);
                AddNewFieldConstraintDialog.this.modeller.reloadLhs();
                AddNewFieldConstraintDialog.this.close();
            }
        });
        button.setLayoutData((Object)gridData);
    }

    private void createVariableBindingRow(Composite composite) {
        this.createLabel(composite, "Variable name");
        final Text text = this.createText(composite, "");
        if (this.pattern.boundName != null) {
            text.setText(this.pattern.boundName);
        }
        Button button = this.toolkit.createButton(composite, "Set", 8);
        button.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ((AddNewFieldConstraintDialog)AddNewFieldConstraintDialog.this).pattern.boundName = text.getText();
                AddNewFieldConstraintDialog.this.modeller.reloadLhs();
                AddNewFieldConstraintDialog.this.modeller.setDirty(true);
                AddNewFieldConstraintDialog.this.close();
            }
        });
    }

    private SuggestionCompletionEngine getCompletion() {
        return this.modeller.getSuggestionCompletionEngine();
    }
}

