/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.rulebuilder.ui;

import org.drools.eclipse.rulebuilder.modeldriven.HumanReadable;
import org.drools.eclipse.rulebuilder.ui.ActionSetFieldDialog;
import org.drools.eclipse.rulebuilder.ui.NumericKeyFilter;
import org.drools.eclipse.rulebuilder.ui.RuleModeller;
import org.drools.eclipse.rulebuilder.ui.Widget;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.client.modeldriven.brl.ActionFieldValue;
import org.drools.ide.common.client.modeldriven.brl.ActionSetField;
import org.drools.ide.common.client.modeldriven.brl.ActionUpdateField;
import org.drools.ide.common.client.modeldriven.brl.FactPattern;
import org.drools.ide.common.client.modeldriven.brl.RuleModel;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;

public class ActionSetFieldWidget
extends Widget {
    private ActionSetField set;
    private final String[] fieldCompletions;
    private boolean isBoundFact = false;
    private String variableClass;

    public ActionSetFieldWidget(FormToolkit formToolkit, Composite composite, RuleModeller ruleModeller, RuleModel ruleModel, ActionSetField actionSetField, int n) {
        super(composite, formToolkit, ruleModeller, n);
        FactPattern factPattern;
        this.set = actionSetField;
        if (this.getCompletion().isGlobalVariable(actionSetField.variable)) {
            this.fieldCompletions = this.getCompletion().getFieldCompletionsForGlobalVariable(actionSetField.variable);
            this.variableClass = this.getCompletion().getGlobalVariable(actionSetField.variable);
        } else {
            factPattern = ruleModel.getBoundFact(actionSetField.variable);
            this.fieldCompletions = this.getCompletion().getFieldCompletions(factPattern.factType);
            this.isBoundFact = true;
            this.variableClass = factPattern.factType;
        }
        factPattern = new GridLayout();
        factPattern.numColumns = 6;
        factPattern.marginBottom = 0;
        factPattern.marginHeight = 0;
        factPattern.marginLeft = 0;
        factPattern.marginRight = 0;
        factPattern.marginTop = 0;
        factPattern.marginWidth = 0;
        factPattern.verticalSpacing = 0;
        composite.setLayout((Layout)factPattern);
        this.create();
    }

    private void create() {
        String string = "set";
        if (this.set instanceof ActionUpdateField) {
            string = "modify";
        }
        this.toolkit.createLabel(this.parent, String.valueOf(HumanReadable.getActionDisplayName(string)) + " [" + this.set.variable + "]");
        this.addDeleteRHSAction();
        this.addMoreOptionsAction();
        this.addRows();
    }

    private void addRows() {
        Composite composite = this.toolkit.createComposite(this.parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        composite.setLayout((Layout)gridLayout);
        int n = 0;
        while (n < this.set.fieldValues.length) {
            ActionFieldValue actionFieldValue = this.set.fieldValues[n];
            this.toolkit.createLabel(composite, actionFieldValue.field);
            this.valueEditor(composite, actionFieldValue);
            this.addRemoveFieldAction(composite, n);
            ++n;
        }
        this.toolkit.paintBordersFor(composite);
    }

    private void addMoreOptionsAction() {
        ImageHyperlink imageHyperlink = this.addImage(this.parent, "icons/new_item.gif");
        imageHyperlink.addHyperlinkListener(new IHyperlinkListener(){

            public void linkActivated(HyperlinkEvent hyperlinkEvent) {
                ActionSetFieldDialog actionSetFieldDialog = new ActionSetFieldDialog(ActionSetFieldWidget.this.parent.getShell(), ActionSetFieldWidget.this.getModeller(), ActionSetFieldWidget.this.set, ActionSetFieldWidget.this.fieldCompletions, ActionSetFieldWidget.this.variableClass);
                actionSetFieldDialog.open();
            }

            public void linkEntered(HyperlinkEvent hyperlinkEvent) {
            }

            public void linkExited(HyperlinkEvent hyperlinkEvent) {
            }
        });
        imageHyperlink.setToolTipText("Add a field");
    }

    private void addRemoveFieldAction(Composite composite, final int n) {
        ImageHyperlink imageHyperlink = this.addImage(composite, "icons/delete_item_small.gif");
        imageHyperlink.setToolTipText("Remove this field action");
        imageHyperlink.addHyperlinkListener(new IHyperlinkListener(){

            public void linkActivated(HyperlinkEvent hyperlinkEvent) {
                MessageBox messageBox = new MessageBox(Display.getCurrent().getActiveShell(), 200);
                messageBox.setMessage("Remove this item?");
                messageBox.setText("Remove this item?");
                if (messageBox.open() == 64) {
                    ActionSetFieldWidget.this.set.removeField(n);
                    ActionSetFieldWidget.this.getModeller().setDirty(true);
                    ActionSetFieldWidget.this.getModeller().reloadRhs();
                }
            }

            public void linkEntered(HyperlinkEvent hyperlinkEvent) {
            }

            public void linkExited(HyperlinkEvent hyperlinkEvent) {
            }
        });
    }

    private void valueEditor(Composite composite, final ActionFieldValue actionFieldValue) {
        final Text text = this.toolkit.createText(composite, "");
        if (actionFieldValue.value != null) {
            text.setText(actionFieldValue.value);
        }
        GridData gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.minimumWidth = 100;
        text.setLayoutData((Object)gridData);
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                actionFieldValue.value = text.getText();
                ActionSetFieldWidget.this.getModeller().setDirty(true);
            }
        });
        if (actionFieldValue.type.equals("Numeric")) {
            new NumericKeyFilter(text);
        }
    }

    private SuggestionCompletionEngine getCompletion() {
        return this.getModeller().getSuggestionCompletionEngine();
    }
}

