/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.rulebuilder.ui;

import org.drools.eclipse.rulebuilder.ui.RuleModeller;
import org.drools.eclipse.rulebuilder.ui.Widget;
import org.drools.ide.common.client.modeldriven.brl.FreeFormLine;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;

public class ActionInsertFreeFormLineWidget
extends Widget {
    private FreeFormLine action;
    private final boolean rhs;

    public ActionInsertFreeFormLineWidget(FormToolkit formToolkit, Composite composite, RuleModeller ruleModeller, FreeFormLine freeFormLine, int n, boolean bl) {
        super(composite, formToolkit, ruleModeller, n);
        this.rhs = bl;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        this.parent.setLayout((Layout)gridLayout);
        this.createTextfield(composite, freeFormLine);
        this.addRemoveFieldAction(this.parent, n);
        formToolkit.paintBordersFor(this.parent);
        this.action = freeFormLine;
    }

    private void createTextfield(Composite composite, final FreeFormLine freeFormLine) {
        final Text text = this.toolkit.createText(composite, freeFormLine.text);
        GridData gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.minimumWidth = 100;
        text.setLayoutData((Object)gridData);
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                ActionInsertFreeFormLineWidget.this.getModeller().setDirty(true);
                freeFormLine.text = text.getText();
            }
        });
    }

    private void addRemoveFieldAction(Composite composite, final int n) {
        ImageHyperlink imageHyperlink = this.addImage(composite, "icons/delete_item_small.gif");
        imageHyperlink.setToolTipText("Remove this field action");
        imageHyperlink.addHyperlinkListener(new IHyperlinkListener(){

            public void linkActivated(HyperlinkEvent hyperlinkEvent) {
                MessageBox messageBox = new MessageBox(Display.getCurrent().getActiveShell(), 200);
                messageBox.setMessage("Remove this item?");
                messageBox.setText("Remove this item?");
                if (messageBox.open() == 64) {
                    if (ActionInsertFreeFormLineWidget.this.rhs) {
                        ActionInsertFreeFormLineWidget.this.getModeller().getModel().removeRhsItem(n);
                        ActionInsertFreeFormLineWidget.this.getModeller().setDirty(true);
                        ActionInsertFreeFormLineWidget.this.getModeller().reloadRhs();
                    } else {
                        ActionInsertFreeFormLineWidget.this.getModeller().getModel().removeLhsItem(n);
                        ActionInsertFreeFormLineWidget.this.getModeller().setDirty(true);
                        ActionInsertFreeFormLineWidget.this.getModeller().reloadLhs();
                    }
                }
            }

            public void linkEntered(HyperlinkEvent hyperlinkEvent) {
            }

            public void linkExited(HyperlinkEvent hyperlinkEvent) {
            }
        });
    }
}

