/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.refactoring;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.drools.eclipse.refactoring.DRLProjectDetector;
import org.drools.eclipse.refactoring.RefactoringContent;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.CompilationUnit;
import org.eclipse.jdt.internal.core.PackageFragment;
import org.eclipse.jdt.internal.corext.refactoring.rename.JavaRenameProcessor;
import org.eclipse.jdt.internal.corext.refactoring.reorg.JavaMoveProcessor;
import org.eclipse.jdt.internal.corext.refactoring.reorg.MoveModifications;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.MoveArguments;
import org.eclipse.ltk.core.refactoring.participants.MoveParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class RuleIFileMoveParticipant
extends MoveParticipant {
    public static final String NAME = "Rule Move Refactoring";
    private static RefactoringContent refactoringContent = new RefactoringContent();
    private DRLProjectDetector drlProjectDetector = new DRLProjectDetector();
    private Matcher matcher;
    private IFile file;
    private RefactoringProcessor processor;
    private String newName;
    private String currentName;
    private String className;

    public RefactoringStatus checkConditions(IProgressMonitor iProgressMonitor, CheckConditionsContext checkConditionsContext) throws OperationCanceledException {
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        if (this.file == null || this.file.isReadOnly()) {
            refactoringStatus.addFatalError("File don't exists or is read only");
        }
        return refactoringStatus;
    }

    public Change createChange(IProgressMonitor iProgressMonitor) throws CoreException, OperationCanceledException {
        CompositeChange compositeChange = new CompositeChange("Reorganize DRL " + this.currentName + "." + this.className + " imports ");
        for (IFile iFile : this.drlProjectDetector.detect(this.file.getProject())) {
            String string = refactoringContent.getIFileContent(iFile);
            if (string == null && (string = this.readFile(iFile)) == null) continue;
            String string2 = String.valueOf(this.currentName) + "." + this.className;
            String string3 = String.valueOf(this.newName) + "." + this.className;
            Pattern pattern = Pattern.compile(string2);
            this.matcher = pattern.matcher(string);
            if (!this.matcher.find()) continue;
            TextFileChange textFileChange = new TextFileChange(iFile.getName(), iFile);
            MultiTextEdit multiTextEdit = new MultiTextEdit();
            textFileChange.setEdit((TextEdit)multiTextEdit);
            ReplaceEdit replaceEdit = new ReplaceEdit(this.matcher.start(), string2.length(), string3);
            multiTextEdit.addChild((TextEdit)replaceEdit);
            compositeChange.add((Change)textFileChange);
            refactoringContent.updateContent(iFile, string.replace(string2, string3));
        }
        return compositeChange.getChildren().length > 0 ? compositeChange : null;
    }

    public String getName() {
        return NAME;
    }

    protected boolean initialize(Object object) {
        IFile iFile;
        if (object instanceof IFile && (iFile = (IFile)object).getType() == 1 && iFile.getFileExtension() != null && iFile.getFileExtension().equalsIgnoreCase("java")) {
            this.processor = this.getProcessor();
            this.file = iFile;
            this.className = iFile.getName().replace("." + iFile.getFileExtension(), "");
            if (this.processor.hashCode() != refactoringContent.getProcessorHashcode().intValue()) {
                refactoringContent.setProcessorHashcode(this.processor.hashCode());
                refactoringContent.clear();
            }
            if (this.processor instanceof JavaRenameProcessor) {
                this.newName = ((JavaRenameProcessor)this.processor).getNewElementName();
                this.currentName = ((JavaRenameProcessor)this.processor).getCurrentElementName();
                return true;
            }
            if (this.processor instanceof JavaMoveProcessor) {
                try {
                    MoveModifications moveModifications = this.getNewName();
                    this.getCurrentName(moveModifications);
                }
                catch (SecurityException securityException) {
                    return false;
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    return false;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return false;
                }
                catch (IllegalAccessException illegalAccessException) {
                    return false;
                }
                catch (JavaModelException javaModelException) {
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    private String readFile(IFile iFile) throws CoreException {
        InputStream inputStream = iFile.getContents();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        StringBuilder stringBuilder = new StringBuilder();
        String string = null;
        try {
            try {
                while ((string = bufferedReader.readLine()) != null) {
                    stringBuilder.append(String.valueOf(string) + "\n");
                }
            }
            catch (IOException iOException) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException2) {}
                return null;
            }
        }
        catch (Throwable throwable) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            inputStream.close();
        }
        catch (IOException iOException) {}
        return stringBuilder.toString();
    }

    private MoveModifications getNewName() throws NoSuchFieldException, IllegalAccessException {
        Field field = this.processor.getClass().getDeclaredField("fMovePolicy");
        field.setAccessible(true);
        Object object = field.get(this.processor);
        Field field2 = object.getClass().getDeclaredField("fModifications");
        field2.setAccessible(true);
        MoveModifications moveModifications = (MoveModifications)field2.get(object);
        Field field3 = moveModifications.getClass().getDeclaredField("fMoveArguments");
        field3.setAccessible(true);
        ArrayList arrayList = (ArrayList)field3.get(moveModifications);
        PackageFragment packageFragment = (PackageFragment)((MoveArguments)arrayList.get(0)).getDestination();
        String[] stringArray = packageFragment.names;
        String string = "";
        int n = 0;
        while (n < stringArray.length) {
            string = string.concat(String.valueOf(stringArray[n]) + ".");
            ++n;
        }
        if (string.length() > 0) {
            this.newName = string.substring(0, string.length() - 1);
        }
        return moveModifications;
    }

    private void getCurrentName(MoveModifications moveModifications) throws NoSuchFieldException, IllegalAccessException, JavaModelException {
        Field field = moveModifications.getClass().getDeclaredField("fMoves");
        field.setAccessible(true);
        ArrayList arrayList = (ArrayList)field.get(moveModifications);
        for (Object e : arrayList) {
            if (!(e instanceof CompilationUnit)) continue;
            CompilationUnit compilationUnit = (CompilationUnit)e;
            IPackageDeclaration[] iPackageDeclarationArray = compilationUnit.getPackageDeclarations();
            int n = 0;
            while (n < iPackageDeclarationArray.length) {
                this.currentName = iPackageDeclarationArray[n].getElementName();
                ++n;
            }
        }
    }
}

