/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.preferences;

import org.drools.eclipse.preferences.DroolsRuntimesBlock;
import org.drools.eclipse.util.DroolsRuntime;
import org.drools.eclipse.util.DroolsRuntimeManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class DroolsRuntimesPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private DroolsRuntimesBlock droolsRuntimesBlock;

    public DroolsRuntimesPreferencePage() {
        super("Installed Drools Runtimes");
    }

    public void init(IWorkbench iWorkbench) {
    }

    protected Control createContents(Composite composite) {
        DroolsRuntime droolsRuntime;
        this.initializeDialogUnits((Control)composite);
        this.noDefaultAndApplyButton();
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite.setLayout((Layout)gridLayout);
        Label label = new Label(composite, 64);
        label.setFont(composite.getFont());
        label.setText("Add, remove or edit Drools Runtime definitions. By default, the checked Drools Runtime is added to the build path of newly created Drools projects.");
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 1;
        gridData.widthHint = 300;
        label.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        gridData = new GridData(768);
        gridData.heightHint = 1;
        label.setLayoutData((Object)gridData);
        this.droolsRuntimesBlock = new DroolsRuntimesBlock();
        this.droolsRuntimesBlock.createControl(composite);
        DroolsRuntime[] droolsRuntimeArray = DroolsRuntimeManager.getDroolsRuntimes();
        this.droolsRuntimesBlock.setDroolsRuntimes(droolsRuntimeArray);
        DroolsRuntime[] droolsRuntimeArray2 = droolsRuntimeArray;
        int n = droolsRuntimeArray.length;
        int n2 = 0;
        while (n2 < n) {
            droolsRuntime = droolsRuntimeArray2[n2];
            if (droolsRuntime.isDefault()) {
                this.droolsRuntimesBlock.setDefaultDroolsRuntime(droolsRuntime);
                break;
            }
            ++n2;
        }
        if (this.droolsRuntimesBlock.getDefaultDroolsRuntime() == null) {
            this.setErrorMessage("Select a default Drools Runtime");
        }
        droolsRuntime = this.droolsRuntimesBlock.getControl();
        GridData gridData2 = new GridData(1808);
        gridData2.horizontalSpan = 1;
        gridData2.widthHint = 450;
        droolsRuntime.setLayoutData(gridData2);
        this.droolsRuntimesBlock.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                DroolsRuntime droolsRuntime = DroolsRuntimesPreferencePage.this.droolsRuntimesBlock.getDefaultDroolsRuntime();
                if (droolsRuntime == null) {
                    DroolsRuntimesPreferencePage.this.setErrorMessage("Select a default Drools Runtime");
                } else {
                    DroolsRuntimesPreferencePage.this.setErrorMessage(null);
                }
            }
        });
        this.applyDialogFont(composite);
        return composite;
    }

    public boolean performOk() {
        if (DroolsRuntimeManager.getDefaultDroolsRuntime() != null) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)"Warning", (String)"You need to restart Eclipse to update the Drools Runtime of existing projects.");
        }
        DroolsRuntimeManager.setDroolsRuntimes(this.droolsRuntimesBlock.getDroolsRuntimes());
        return super.performOk();
    }
}

