/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.launching;

import com.sun.jdi.VirtualMachine;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import com.sun.jdi.connect.ListeningConnector;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.drools.eclipse.debug.core.DroolsDebugModel;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.jdi.Bootstrap;
import org.eclipse.jdt.internal.launching.LaunchingMessages;
import org.eclipse.jdt.internal.launching.LaunchingPlugin;
import org.eclipse.jdt.internal.launching.LibraryInfo;
import org.eclipse.jdt.internal.launching.StandardVMDebugger;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.SocketUtil;
import org.eclipse.jdt.launching.VMRunnerConfiguration;

public class DroolsVMDebugger
extends StandardVMDebugger {
    public DroolsVMDebugger(IVMInstall iVMInstall) {
        super(iVMInstall);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void run(VMRunnerConfiguration var1_1, ILaunch var2_2, IProgressMonitor var3_3) throws CoreException {
        if (var3_3 == null) {
            var3_3 = new NullProgressMonitor();
        }
        var4_4 = new SubProgressMonitor(var3_3, 1);
        var4_4.beginTask(LaunchingMessages.StandardVMDebugger_Launching_VM____1, 4);
        var4_4.subTask(LaunchingMessages.StandardVMDebugger_Finding_free_socket____2);
        var5_5 = SocketUtil.findFreePort();
        if (var5_5 == -1) {
            this.abort(LaunchingMessages.StandardVMDebugger_Could_not_find_a_free_socket_for_the_debugger_1, null, 118);
        }
        var4_4.worked(1);
        if (var3_3.isCanceled()) {
            return;
        }
        var4_4.subTask(LaunchingMessages.StandardVMDebugger_Constructing_command_line____3);
        var6_6 = this.constructProgramString(var1_1);
        var7_7 = new ArrayList<String>(12);
        var7_7.add(var6_6);
        var8_8 = this.combineVmArgs(var1_1, this.fVMInstance);
        this.addArguments(var8_8, var7_7);
        var7_7.add("-Dmvel.debugger=true");
        this.addBootClassPathArguments(var7_7, var1_1);
        var9_9 = var1_1.getClassPath();
        if (var9_9.length > 0) {
            var7_7.add("-classpath");
            var7_7.add(this.convertClassPath(var9_9));
        }
        if ((var10_10 = this.getJavaVersion()) < 1.5) {
            var7_7.add("-Xdebug");
            var7_7.add("-Xnoagent");
        }
        if (var10_10 < 1.4) {
            var7_7.add("-Djava.compiler=NONE");
        }
        if (var10_10 < 1.5) {
            var7_7.add("-Xrunjdwp:transport=dt_socket,suspend=y,address=localhost:" + var5_5);
        } else {
            var7_7.add("-agentlib:jdwp=transport=dt_socket,suspend=y,address=localhost:" + var5_5);
        }
        var7_7.add(var1_1.getClassToLaunch());
        this.addArguments(var1_1.getProgramArguments(), var7_7);
        var12_11 = new String[var7_7.size()];
        var7_7.toArray(var12_11);
        var13_12 = var1_1.getEnvironment();
        if (var3_3.isCanceled()) {
            return;
        }
        var4_4.worked(1);
        var4_4.subTask(LaunchingMessages.StandardVMDebugger_Starting_virtual_machine____4);
        var14_13 = this.getConnector();
        if (var14_13 == null) {
            this.abort(LaunchingMessages.StandardVMDebugger_Couldn__t_find_an_appropriate_debug_connector_2, null, 119);
        }
        var15_14 = var14_13.defaultArguments();
        this.specifyArguments(var15_14, var5_5);
        var16_15 = null;
        try {
            try {
                if (var3_3.isCanceled()) {
                    return;
                }
                var14_13.startListening(var15_14);
                var17_16 = this.getWorkingDir(var1_1);
                var16_15 = this.exec(var12_11, var17_16, var13_12);
                if (var16_15 == null) {
                    return;
                }
                if (var3_3.isCanceled()) {
                    var16_15.destroy();
                    return;
                }
                var18_19 = this.newProcess(var2_2, var16_15, DroolsVMDebugger.renderProcessLabel((String[])var12_11), this.getDefaultProcessMap());
                var18_19.setAttribute(IProcess.ATTR_CMDLINE, this.renderCommandLineInternal(var12_11));
                var4_4.worked(1);
                var4_4.subTask(LaunchingMessages.StandardVMDebugger_Establishing_debug_connection____5);
                var19_20 = false;
                while (true) {
                    try {
                        var20_22 = new ConnectRunnable(var14_13, var15_14);
                        var21_23 = new Thread((Runnable)var20_22, "Listening Connector");
                        var21_23.setDaemon(true);
                        var21_23.start();
                        while (var21_23.isAlive()) {
                            if (!var3_3.isCanceled()) ** break block40
                            var14_13.stopListening(var15_14);
                            var16_15.destroy();
                            return;
                        }
                    }
                    catch (InterruptedIOException var20_21) {
                        this.checkErrorMessage(var18_19);
                        var21_23 = new Status(4, LaunchingPlugin.getUniqueIdentifier(), 117, "", (Throwable)var20_21);
                        var22_24 /* !! */  = DebugPlugin.getDefault().getStatusHandler((IStatus)var21_23);
                        var19_20 = false;
                        if (var22_24 /* !! */  == null) {
                            throw new CoreException((IStatus)var21_23);
                        }
                        var23_25 = var22_24 /* !! */ .handleStatus((IStatus)var21_23, (Object)this);
                        if (!(var23_25 instanceof Boolean)) continue;
                        var19_20 = (Boolean)var23_25;
                        if (var19_20) continue;
                        break;
                    }
                    {
                        try {
                            var16_15.exitValue();
                            try {
                                var14_13.stopListening(var15_14);
                            }
                            catch (IOException v0) {}
                            this.checkErrorMessage(var18_19);
                        }
                        catch (IllegalThreadStateException v1) {}
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException v2) {}
                        continue;
                    }
                    var22_24 /* !! */  = var20_22.getException();
                    if (var22_24 /* !! */  instanceof IllegalConnectorArgumentsException) {
                        throw (IllegalConnectorArgumentsException)var22_24 /* !! */ ;
                    }
                    if (var22_24 /* !! */  instanceof InterruptedIOException) {
                        throw (InterruptedIOException)var22_24 /* !! */ ;
                    }
                    if (var22_24 /* !! */  instanceof IOException) {
                        throw (IOException)var22_24 /* !! */ ;
                    }
                    var23_25 = var20_22.getVirtualMachine();
                    if (var23_25 != null) {
                        DroolsDebugModel.newDebugTarget(var2_2, (VirtualMachine)var23_25, this.renderDebugTarget(var1_1.getClassToLaunch(), var5_5), var18_19, true, false, var1_1.isResumeOnStartup());
                        var4_4.worked(1);
                        var4_4.done();
                    }
                    return;
                }
            }
            finally {
                var14_13.stopListening(var15_14);
            }
        }
        catch (IOException var17_17) {
            this.abort(LaunchingMessages.StandardVMDebugger_Couldn__t_connect_to_VM_4, var17_17, 120);
        }
        catch (IllegalConnectorArgumentsException var17_18) {
            this.abort(LaunchingMessages.StandardVMDebugger_Couldn__t_connect_to_VM_5, var17_18, 120);
        }
        if (var16_15 != null) {
            var16_15.destroy();
        }
    }

    private String renderCommandLineInternal(String[] stringArray) {
        if (stringArray.length < 1) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < stringArray.length) {
            stringBuffer.append(' ');
            char[] cArray = stringArray[n].toCharArray();
            StringBuffer stringBuffer2 = new StringBuffer();
            boolean bl = false;
            int n2 = 0;
            while (n2 < cArray.length) {
                char c = cArray[n2];
                if (c == '\"') {
                    stringBuffer2.append('\\');
                } else if (c == ' ') {
                    bl = true;
                }
                stringBuffer2.append(c);
                ++n2;
            }
            if (bl) {
                stringBuffer.append('\"');
                stringBuffer.append(stringBuffer2.toString());
                stringBuffer.append('\"');
            } else {
                stringBuffer.append(stringBuffer2.toString());
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    private double getJavaVersion() {
        LibraryInfo libraryInfo = LaunchingPlugin.getLibraryInfo((String)this.fVMInstance.getInstallLocation().getAbsolutePath());
        if (libraryInfo == null) {
            return 0.0;
        }
        String string = libraryInfo.getVersion();
        int n = string.indexOf(".");
        int n2 = string.indexOf(".", n + 1);
        try {
            if (n > 0 && n2 > n) {
                return Double.parseDouble(string.substring(0, n2));
            }
            return Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            return 0.0;
        }
    }

    protected void checkErrorMessage(IProcess iProcess) throws CoreException {
        IStreamsProxy iStreamsProxy = iProcess.getStreamsProxy();
        if (iStreamsProxy != null) {
            String string = iStreamsProxy.getErrorStreamMonitor().getContents();
            if (string.length() == 0) {
                string = iStreamsProxy.getOutputStreamMonitor().getContents();
            }
            if (string.length() != 0) {
                this.abort(string, null, 116);
            }
        }
    }

    protected void specifyArguments(Map map, int n) {
        Connector.IntegerArgument integerArgument = (Connector.IntegerArgument)map.get("port");
        integerArgument.setValue(n);
        Connector.IntegerArgument integerArgument2 = (Connector.IntegerArgument)map.get("timeout");
        if (integerArgument2 != null) {
            int n2 = JavaRuntime.getPreferences().getInt(JavaRuntime.PREF_CONNECT_TIMEOUT);
            integerArgument2.setValue(n2);
        }
    }

    protected ListeningConnector getConnector() {
        List<ListeningConnector> list = Bootstrap.virtualMachineManager().listeningConnectors();
        int n = 0;
        while (n < list.size()) {
            ListeningConnector listeningConnector = list.get(n);
            if ("com.sun.jdi.SocketListen".equals(listeningConnector.name())) {
                return listeningConnector;
            }
            ++n;
        }
        return null;
    }

    class ConnectRunnable
    implements Runnable {
        private VirtualMachine fVirtualMachine = null;
        private ListeningConnector fConnector = null;
        private Map fConnectionMap = null;
        private Exception fException = null;

        public ConnectRunnable(ListeningConnector listeningConnector, Map map) {
            this.fConnector = listeningConnector;
            this.fConnectionMap = map;
        }

        public void run() {
            try {
                this.fVirtualMachine = this.fConnector.accept(this.fConnectionMap);
            }
            catch (IOException iOException) {
                this.fException = iOException;
            }
            catch (IllegalConnectorArgumentsException illegalConnectorArgumentsException) {
                this.fException = illegalConnectorArgumentsException;
            }
        }

        public VirtualMachine getVirtualMachine() {
            return this.fVirtualMachine;
        }

        public Exception getException() {
            return this.fException;
        }
    }
}

