/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.flow.ruleflow.view.property.timers;

import java.util.List;
import java.util.Map;
import org.drools.core.util.ArrayUtils;
import org.drools.eclipse.editors.DRLSourceViewerConfig;
import org.drools.eclipse.editors.scanners.DRLPartionScanner;
import org.drools.eclipse.flow.common.view.property.EditBeanDialog;
import org.drools.eclipse.flow.common.view.property.MapItemDialog;
import org.drools.eclipse.flow.ruleflow.view.property.action.ActionCompletionProcessor;
import org.drools.eclipse.flow.ruleflow.view.property.constraint.RuleFlowGlobalsDialog;
import org.drools.eclipse.flow.ruleflow.view.property.constraint.RuleFlowImportsDialog;
import org.drools.process.core.timer.Timer;
import org.drools.workflow.core.DroolsAction;
import org.drools.workflow.core.WorkflowProcess;
import org.drools.workflow.core.impl.DroolsConsequenceAction;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimerDialog
extends EditBeanDialog<DroolsAction>
implements MapItemDialog<Timer> {
    private static final String[] DIALECTS = new String[]{"mvel", "java"};
    private Timer timer;
    private Text delayText;
    private Text periodText;
    private WorkflowProcess process;
    private TabFolder tabFolder;
    private SourceViewer actionViewer;
    private Combo dialectCombo;
    private ActionCompletionProcessor completionProcessor;

    public TimerDialog(Shell shell, WorkflowProcess workflowProcess) {
        super(shell, "Edit Timer");
        this.process = workflowProcess;
    }

    @Override
    protected Point getInitialSize() {
        return new Point(400, 500);
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        Label label = new Label(composite2, 0);
        label.setText("Timer delay: ");
        this.delayText = new Text(composite2, 0);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.delayText.setLayoutData((Object)gridData);
        if (this.timer != null && this.timer.getDelay() != null) {
            this.delayText.setText(this.timer.getDelay());
        }
        label = new Label(composite2, 0);
        label.setText("Timer period: ");
        this.periodText = new Text(composite2, 0);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.periodText.setLayoutData((Object)gridData);
        if (this.timer != null && this.timer.getPeriod() != null) {
            this.periodText.setText(this.timer.getPeriod());
        }
        Composite composite3 = new Composite(composite2, 0);
        GridData gridData2 = new GridData();
        gridData2.horizontalSpan = 2;
        gridData2.grabExcessHorizontalSpace = true;
        composite3.setLayoutData((Object)gridData2);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        composite3.setLayout((Layout)gridLayout);
        label = new Label(composite3, 0);
        label.setText("Dialect:");
        this.createDialectCombo(composite3);
        Button button = new Button(composite3, 8);
        button.setText("Imports ...");
        button.setFont(JFaceResources.getDialogFont());
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TimerDialog.this.importButtonPressed();
            }
        });
        Button button2 = new Button(composite3, 8);
        button2.setText("Globals ...");
        button2.setFont(JFaceResources.getDialogFont());
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TimerDialog.this.globalButtonPressed();
            }
        });
        this.tabFolder = new TabFolder(composite2, 0);
        gridData2 = new GridData();
        gridData2.horizontalSpan = 3;
        gridData2.grabExcessHorizontalSpace = true;
        gridData2.grabExcessVerticalSpace = true;
        gridData2.verticalAlignment = 4;
        gridData2.horizontalAlignment = 4;
        this.tabFolder.setLayoutData((Object)gridData2);
        TabItem tabItem = new TabItem(this.tabFolder, 0);
        tabItem.setText("Textual Editor");
        tabItem.setControl(this.createTextualEditor((Composite)this.tabFolder));
        return composite2;
    }

    private Control createTextualEditor(Composite composite) {
        this.actionViewer = new SourceViewer(composite, null, 2048);
        this.actionViewer.configure((SourceViewerConfiguration)new DRLSourceViewerConfig(null){

            public IReconciler getReconciler(ISourceViewer iSourceViewer) {
                return null;
            }

            public IContentAssistant getContentAssistant(ISourceViewer iSourceViewer) {
                ContentAssistant contentAssistant = new ContentAssistant();
                TimerDialog.this.completionProcessor = new ActionCompletionProcessor(TimerDialog.this.process);
                contentAssistant.setContentAssistProcessor((IContentAssistProcessor)TimerDialog.this.completionProcessor, "__dftl_partition_content_type");
                contentAssistant.setProposalPopupOrientation(10);
                return contentAssistant;
            }
        });
        this.completionProcessor.setDialect(this.dialectCombo.getItem(this.dialectCombo.getSelectionIndex()));
        DroolsAction droolsAction = (DroolsAction)this.getValue();
        String string = null;
        if (droolsAction instanceof DroolsConsequenceAction) {
            string = ((DroolsConsequenceAction)droolsAction).getConsequence();
        }
        if (string == null) {
            string = "";
        }
        Document document = new Document(string);
        this.actionViewer.setDocument((IDocument)document);
        FastPartitioner fastPartitioner = new FastPartitioner((IPartitionTokenScanner)new DRLPartionScanner(), DRLPartionScanner.LEGAL_CONTENT_TYPES);
        fastPartitioner.connect((IDocument)document);
        document.setDocumentPartitioner((IDocumentPartitioner)fastPartitioner);
        this.actionViewer.getControl().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.character == ' ' && keyEvent.stateMask == 262144) {
                    TimerDialog.this.actionViewer.doOperation(13);
                }
            }

            public void keyReleased(KeyEvent keyEvent) {
            }
        });
        return this.actionViewer.getControl();
    }

    private Control createDialectCombo(Composite composite) {
        String string;
        int n;
        this.dialectCombo = new Combo(composite, 12);
        this.dialectCombo.setItems(DIALECTS);
        DroolsAction droolsAction = (DroolsAction)this.getValue();
        int n2 = 0;
        if (droolsAction instanceof DroolsConsequenceAction && (n = ArrayUtils.indexOf((Object[])DIALECTS, (Object)(string = ((DroolsConsequenceAction)droolsAction).getDialect()))) >= 0) {
            n2 = n;
        }
        this.dialectCombo.select(n2);
        this.dialectCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                TimerDialog.this.completionProcessor.setDialect(TimerDialog.this.dialectCombo.getItem(TimerDialog.this.dialectCombo.getSelectionIndex()));
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                TimerDialog.this.completionProcessor.setDialect(TimerDialog.this.dialectCombo.getItem(TimerDialog.this.dialectCombo.getSelectionIndex()));
            }
        });
        return this.dialectCombo;
    }

    private DroolsConsequenceAction getAction() {
        return new DroolsConsequenceAction(this.dialectCombo.getItem(this.dialectCombo.getSelectionIndex()), this.actionViewer.getDocument().get());
    }

    private void importButtonPressed() {
        Runnable runnable = new Runnable(){

            public void run() {
                RuleFlowImportsDialog ruleFlowImportsDialog = new RuleFlowImportsDialog(TimerDialog.this.getShell(), TimerDialog.this.process);
                ruleFlowImportsDialog.create();
                int n = ruleFlowImportsDialog.open();
                if (n != 1) {
                    List<String> list = ruleFlowImportsDialog.getImports();
                    TimerDialog.this.process.setImports(list);
                    TimerDialog.this.completionProcessor.reset();
                }
            }
        };
        runnable.run();
    }

    private void globalButtonPressed() {
        Runnable runnable = new Runnable(){

            public void run() {
                RuleFlowGlobalsDialog ruleFlowGlobalsDialog = new RuleFlowGlobalsDialog(TimerDialog.this.getShell(), TimerDialog.this.process);
                ruleFlowGlobalsDialog.create();
                int n = ruleFlowGlobalsDialog.open();
                if (n != 1) {
                    Map<String, String> map = ruleFlowGlobalsDialog.getGlobals();
                    TimerDialog.this.process.setGlobals(map);
                    TimerDialog.this.completionProcessor.reset();
                }
            }
        };
        runnable.run();
    }

    @Override
    protected DroolsAction updateValue(DroolsAction droolsAction) {
        String string;
        if (this.timer == null) {
            this.timer = new Timer();
        }
        if ((string = this.delayText.getText().trim()).length() == 0) {
            this.timer.setDelay(null);
        } else {
            this.timer.setDelay(string);
        }
        String string2 = this.periodText.getText().trim();
        if (string2.length() == 0) {
            this.timer.setPeriod(null);
        } else {
            this.timer.setPeriod(string2);
        }
        if (this.tabFolder.getSelectionIndex() == 0) {
            return this.getAction();
        }
        return null;
    }

    @Override
    public void setKey(Timer timer) {
        this.timer = timer;
    }

    @Override
    public Timer getKey() {
        return this.timer;
    }
}

