/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.flow.ruleflow.view.property.subprocess;

import java.util.HashMap;
import java.util.Map;
import org.drools.eclipse.flow.common.view.property.EditBeanDialog;
import org.drools.workflow.core.node.SubProcessNode;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class SubProcessParameterInMappingDialog
extends EditBeanDialog
implements FocusListener,
MouseListener {
    private Table table;
    private Button removeButton;
    private Text text;
    private TableEditor editor;
    private int selectedColumn = -1;

    public SubProcessParameterInMappingDialog(Shell shell, SubProcessNode subProcessNode) {
        super(shell, "Parameter In Mapping");
        this.setValue(subProcessNode.getInMappings());
    }

    protected Object updateValue(Object object) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        TableItem[] tableItemArray = this.table.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem tableItem = tableItemArray[n2];
            hashMap.put(tableItem.getText(0), tableItem.getText(1));
            ++n2;
        }
        return hashMap;
    }

    protected Point getInitialSize() {
        return new Point(450, 300);
    }

    public Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        this.table = new Table(composite2, 4);
        GridData gridData = new GridData();
        gridData.verticalSpan = 3;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.verticalAlignment = 4;
        gridData.horizontalAlignment = 4;
        this.table.setLayoutData((Object)gridData);
        this.table.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                SubProcessParameterInMappingDialog.this.removeButton.setEnabled(SubProcessParameterInMappingDialog.this.table.getSelectionIndex() != -1);
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                SubProcessParameterInMappingDialog.this.removeButton.setEnabled(SubProcessParameterInMappingDialog.this.table.getSelectionIndex() != -1);
            }
        });
        this.table.addMouseListener((MouseListener)this);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        TableColumn tableColumn = new TableColumn(this.table, 16384);
        tableColumn.setText("Sub Process Variable");
        tableColumn.setWidth(150);
        TableColumn tableColumn2 = new TableColumn(this.table, 16384);
        tableColumn2.setText("Process Variable");
        tableColumn2.setWidth(225);
        this.editor = new TableEditor(this.table);
        this.text = new Text((Composite)this.table, 0);
        this.text.setVisible(false);
        this.text.setText("");
        this.editor.minimumWidth = this.text.getSize().x;
        this.editor.horizontalAlignment = 16384;
        this.editor.grabHorizontal = true;
        Button button = new Button(composite2, 8);
        button.setText("Add");
        button.setFont(JFaceResources.getDialogFont());
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                SubProcessParameterInMappingDialog.this.addButtonPressed();
            }
        });
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        button.setLayoutData((Object)gridData);
        this.removeButton = new Button(composite2, 8);
        this.removeButton.setText("Remove");
        this.removeButton.setFont(JFaceResources.getDialogFont());
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                SubProcessParameterInMappingDialog.this.removeButtonPressed();
            }
        });
        gridData = new GridData();
        this.removeButton.setLayoutData((Object)gridData);
        this.removeButton.setEnabled(false);
        this.updateTable();
        return composite2;
    }

    private void updateTable() {
        Map map = (Map)this.getValue();
        for (Map.Entry entry : map.entrySet()) {
            TableItem tableItem = new TableItem(this.table, 0);
            tableItem.setText(new String[]{(String)entry.getKey(), (String)entry.getValue()});
        }
    }

    private void addButtonPressed() {
        TableItem tableItem = new TableItem(this.table, 0);
        tableItem.setText(0, "variable");
        tableItem.setText(1, "variable");
        this.table.setSelection(tableItem);
    }

    private void removeButtonPressed() {
        int n = this.table.getSelectionIndex();
        if (n == -1) {
            return;
        }
        this.table.remove(n);
        this.removeButton.setEnabled(this.table.getItemCount() == 0);
    }

    private void doEdit() {
        if (this.text.isVisible()) {
            this.endEdit();
        }
        if (this.table.getSelectionIndex() == -1 || this.selectedColumn == -1) {
            return;
        }
        TableItem tableItem = this.table.getItem(this.table.getSelectionIndex());
        String string = tableItem.getText(this.selectedColumn);
        this.text.setText(string == null ? "" : string);
        this.editor.setEditor((Control)this.text, tableItem, this.selectedColumn);
        this.text.setVisible(true);
        this.text.selectAll();
        this.text.setFocus();
        this.text.addFocusListener((FocusListener)this);
    }

    private void endEdit() {
        this.text.setVisible(false);
        this.text.setText("");
        this.text.removeFocusListener((FocusListener)this);
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        if (focusEvent.widget == this.text) {
            this.applyValue();
            this.endEdit();
        }
    }

    public void mouseDoubleClick(MouseEvent mouseEvent) {
    }

    public void mouseDown(MouseEvent mouseEvent) {
        this.selectedColumn = this.getSelectedColumn(mouseEvent.x, mouseEvent.y);
        if (this.selectedColumn == -1) {
            return;
        }
        this.doEdit();
    }

    public void mouseUp(MouseEvent mouseEvent) {
    }

    private int getSelectedColumn(int n, int n2) {
        int n3 = -1;
        int n4 = this.table.getColumnCount();
        if (this.table.getSelection().length == 0) {
            return -1;
        }
        int n5 = 0;
        while (n5 < n4) {
            Rectangle rectangle = this.table.getSelection()[0].getBounds(n5);
            if (rectangle.contains(n, n2)) {
                n3 = n5;
                break;
            }
            ++n5;
        }
        return n3;
    }

    private void applyValue() {
        int n = this.table.getSelectionIndex();
        if (n == -1) {
            return;
        }
        TableItem tableItem = this.table.getItem(n);
        tableItem.setText(this.selectedColumn, this.text.getText());
    }
}

