/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.flow.ruleflow.view.property.constraint;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.drools.eclipse.editors.DRLSourceViewerConfig;
import org.drools.eclipse.editors.scanners.DRLPartionScanner;
import org.drools.eclipse.flow.ruleflow.view.property.constraint.GlobalCompletionProcessor;
import org.drools.workflow.core.WorkflowProcess;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuleFlowGlobalsDialog
extends Dialog {
    private static final Pattern GLOBAL_PATTERN = Pattern.compile("\\n\\s*global\\s+([^\\s;#]+)\\s+([^\\s;#]+);?", 32);
    private WorkflowProcess process;
    private boolean success;
    private TabFolder tabFolder;
    private SourceViewer globalsViewer;
    private Map<String, String> globals;

    public RuleFlowGlobalsDialog(Shell shell, WorkflowProcess workflowProcess) {
        super(shell);
        this.process = workflowProcess;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Globals editor");
    }

    protected Point getInitialSize() {
        return new Point(600, 450);
    }

    private Control createTextualEditor(Composite composite) {
        this.globalsViewer = new SourceViewer(composite, null, 2048);
        this.globalsViewer.configure((SourceViewerConfiguration)new DRLSourceViewerConfig(null){

            public IReconciler getReconciler(ISourceViewer iSourceViewer) {
                return null;
            }

            public IContentAssistant getContentAssistant(ISourceViewer iSourceViewer) {
                ContentAssistant contentAssistant = new ContentAssistant();
                GlobalCompletionProcessor globalCompletionProcessor = new GlobalCompletionProcessor();
                contentAssistant.setContentAssistProcessor((IContentAssistProcessor)globalCompletionProcessor, "__dftl_partition_content_type");
                contentAssistant.setProposalPopupOrientation(10);
                return contentAssistant;
            }
        });
        Document document = new Document(this.getProcessImports());
        this.globalsViewer.setDocument((IDocument)document);
        FastPartitioner fastPartitioner = new FastPartitioner((IPartitionTokenScanner)new DRLPartionScanner(), DRLPartionScanner.LEGAL_CONTENT_TYPES);
        fastPartitioner.connect((IDocument)document);
        document.setDocumentPartitioner((IDocumentPartitioner)fastPartitioner);
        this.globalsViewer.getControl().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.character == ' ' && keyEvent.stateMask == 262144) {
                    RuleFlowGlobalsDialog.this.globalsViewer.doOperation(13);
                }
            }

            public void keyReleased(KeyEvent keyEvent) {
            }
        });
        return this.globalsViewer.getControl();
    }

    private String getProcessImports() {
        String string = "# define your globals here: e.g. global java.util.List myList\n";
        Map map = this.process.getGlobals();
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                string = String.valueOf(string) + "global " + (String)entry.getValue() + " " + (String)entry.getKey() + "\n";
            }
        }
        return string;
    }

    public Control createDialogArea(Composite composite) {
        GridLayout gridLayout = new GridLayout();
        composite.setLayout((Layout)gridLayout);
        gridLayout.numColumns = 1;
        this.tabFolder = new TabFolder(composite, 0);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.verticalAlignment = 4;
        gridData.horizontalAlignment = 4;
        this.tabFolder.setLayoutData((Object)gridData);
        TabItem tabItem = new TabItem(this.tabFolder, 0);
        tabItem.setText("Globals");
        tabItem.setControl(this.createTextualEditor((Composite)this.tabFolder));
        return this.tabFolder;
    }

    protected void okPressed() {
        this.success = true;
        this.updateGlobals();
        super.okPressed();
    }

    public boolean isSuccess() {
        return this.success;
    }

    public Map<String, String> getGlobals() {
        return this.globals;
    }

    private void updateGlobals() {
        this.globals = new HashMap<String, String>();
        Matcher matcher = GLOBAL_PATTERN.matcher(this.globalsViewer.getDocument().get());
        while (matcher.find()) {
            this.globals.put(matcher.group(2), matcher.group(1));
        }
    }
}

