/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.flow.ruleflow.view.property.constraint;

import java.util.List;
import java.util.Map;
import org.drools.core.util.ArrayUtils;
import org.drools.eclipse.editors.DRLSourceViewerConfig;
import org.drools.eclipse.editors.scanners.DRLPartionScanner;
import org.drools.eclipse.flow.ruleflow.view.property.constraint.ConstraintCompletionProcessor;
import org.drools.eclipse.flow.ruleflow.view.property.constraint.RuleFlowGlobalsDialog;
import org.drools.eclipse.flow.ruleflow.view.property.constraint.RuleFlowImportsDialog;
import org.drools.workflow.core.Constraint;
import org.drools.workflow.core.WorkflowProcess;
import org.drools.workflow.core.impl.ConstraintImpl;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;

public class RuleFlowConstraintDialog
extends Dialog {
    private static final String[] DIALECTS = new String[]{"mvel", "java"};
    private static final String[] TYPES = new String[]{"rule", "code"};
    private Constraint constraint;
    private WorkflowProcess process;
    private boolean success;
    private Button alwaysTrue;
    private Text nameText;
    private Text priorityText;
    private Combo typeCombo;
    private Combo dialectCombo;
    private TabFolder tabFolder;
    private SourceViewer constraintViewer;
    private ConstraintCompletionProcessor completionProcessor;

    public RuleFlowConstraintDialog(Shell shell, WorkflowProcess workflowProcess) {
        super(shell);
        this.process = workflowProcess;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Constraint editor");
    }

    protected Point getInitialSize() {
        return new Point(600, 450);
    }

    private Control createTextualEditor(Composite composite) {
        this.constraintViewer = new SourceViewer(composite, null, 2048);
        this.constraintViewer.configure((SourceViewerConfiguration)new DRLSourceViewerConfig(null){

            public IReconciler getReconciler(ISourceViewer iSourceViewer) {
                return null;
            }

            public IContentAssistant getContentAssistant(ISourceViewer iSourceViewer) {
                ContentAssistant contentAssistant = new ContentAssistant();
                RuleFlowConstraintDialog.this.completionProcessor = new ConstraintCompletionProcessor(RuleFlowConstraintDialog.this.process);
                contentAssistant.setContentAssistProcessor((IContentAssistProcessor)RuleFlowConstraintDialog.this.completionProcessor, "__dftl_partition_content_type");
                contentAssistant.setProposalPopupOrientation(10);
                return contentAssistant;
            }
        });
        Document document = new Document();
        this.constraintViewer.setDocument((IDocument)document);
        FastPartitioner fastPartitioner = new FastPartitioner((IPartitionTokenScanner)new DRLPartionScanner(), DRLPartionScanner.LEGAL_CONTENT_TYPES);
        fastPartitioner.connect((IDocument)document);
        document.setDocumentPartitioner((IDocumentPartitioner)fastPartitioner);
        this.constraintViewer.getControl().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.character == ' ' && keyEvent.stateMask == 262144) {
                    RuleFlowConstraintDialog.this.constraintViewer.doOperation(13);
                }
            }

            public void keyReleased(KeyEvent keyEvent) {
            }
        });
        return this.constraintViewer.getControl();
    }

    private String getConstraintText() {
        return this.constraintViewer.getDocument().get();
    }

    private void setConstraintText(String string) {
        this.constraintViewer.getDocument().set(string);
    }

    public Control createDialogArea(Composite composite) {
        GridLayout gridLayout = new GridLayout();
        composite.setLayout((Layout)gridLayout);
        gridLayout.numColumns = 2;
        Composite composite2 = new Composite(composite, 0);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.grabExcessHorizontalSpace = true;
        composite2.setLayoutData((Object)gridData);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        composite2.setLayout((Layout)gridLayout);
        Label label = new Label(composite2, 0);
        label.setText("Name:");
        gridData = new GridData();
        label.setLayoutData((Object)gridData);
        this.nameText = new Text(composite2, 2048);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.widthHint = 200;
        gridData.horizontalSpan = 3;
        this.nameText.setLayoutData((Object)gridData);
        Label label2 = new Label(composite2, 0);
        gridData = new GridData();
        label2.setLayoutData((Object)gridData);
        label2.setText("Priority:");
        this.priorityText = new Text(composite2, 2048);
        gridData = new GridData();
        gridData.widthHint = 200;
        gridData.horizontalSpan = 3;
        this.priorityText.setLayoutData((Object)gridData);
        this.alwaysTrue = new Button(composite2, 32);
        this.alwaysTrue.setText("Always true");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        this.alwaysTrue.setLayoutData((Object)gridData);
        Button button = new Button(composite2, 8);
        button.setText("Imports ...");
        button.setFont(JFaceResources.getDialogFont());
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                RuleFlowConstraintDialog.this.importButtonPressed();
            }
        });
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 3;
        button.setLayoutData((Object)gridData);
        Button button2 = new Button(composite2, 8);
        button2.setText("Globals ...");
        button2.setFont(JFaceResources.getDialogFont());
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                RuleFlowConstraintDialog.this.globalButtonPressed();
            }
        });
        gridData = new GridData();
        gridData.horizontalAlignment = 3;
        button2.setLayoutData((Object)gridData);
        Label label3 = new Label(composite2, 0);
        gridData = new GridData();
        label3.setLayoutData((Object)gridData);
        label3.setText("Type:");
        this.typeCombo = new Combo(composite2, 12);
        this.typeCombo.setItems(TYPES);
        gridData = new GridData();
        this.typeCombo.setLayoutData((Object)gridData);
        this.typeCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (RuleFlowConstraintDialog.this.completionProcessor != null) {
                    RuleFlowConstraintDialog.this.completionProcessor.setType(RuleFlowConstraintDialog.this.typeCombo.getText());
                }
            }
        });
        this.typeCombo.select(0);
        Label label4 = new Label(composite2, 0);
        gridData = new GridData();
        label4.setLayoutData((Object)gridData);
        label4.setText("Dialect:");
        this.dialectCombo = new Combo(composite2, 12);
        this.dialectCombo.setItems(DIALECTS);
        this.dialectCombo.select(0);
        gridData = new GridData();
        this.dialectCombo.setLayoutData((Object)gridData);
        this.tabFolder = new TabFolder(composite, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.verticalAlignment = 4;
        gridData.horizontalAlignment = 4;
        this.tabFolder.setLayoutData((Object)gridData);
        TabItem tabItem = new TabItem(this.tabFolder, 0);
        tabItem.setText("Textual Editor");
        tabItem.setControl(this.createTextualEditor((Composite)this.tabFolder));
        this.alwaysTrue.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                RuleFlowConstraintDialog.this.tabFolder.setVisible(!RuleFlowConstraintDialog.this.alwaysTrue.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                this.widgetSelected(selectionEvent);
            }
        });
        return this.tabFolder;
    }

    private void importButtonPressed() {
        Runnable runnable = new Runnable(){

            public void run() {
                RuleFlowImportsDialog ruleFlowImportsDialog = new RuleFlowImportsDialog(RuleFlowConstraintDialog.this.getShell(), RuleFlowConstraintDialog.this.process);
                ruleFlowImportsDialog.create();
                int n = ruleFlowImportsDialog.open();
                if (n != 1) {
                    List<String> list = ruleFlowImportsDialog.getImports();
                    RuleFlowConstraintDialog.this.process.setImports(list);
                    RuleFlowConstraintDialog.this.completionProcessor.reset();
                }
            }
        };
        runnable.run();
    }

    private void globalButtonPressed() {
        Runnable runnable = new Runnable(){

            public void run() {
                RuleFlowGlobalsDialog ruleFlowGlobalsDialog = new RuleFlowGlobalsDialog(RuleFlowConstraintDialog.this.getShell(), RuleFlowConstraintDialog.this.process);
                ruleFlowGlobalsDialog.create();
                int n = ruleFlowGlobalsDialog.open();
                if (n != 1) {
                    Map<String, String> map = ruleFlowGlobalsDialog.getGlobals();
                    RuleFlowConstraintDialog.this.process.setGlobals(map);
                    RuleFlowConstraintDialog.this.completionProcessor.reset();
                }
            }
        };
        runnable.run();
    }

    public void fixType(int n) {
        this.typeCombo.select(n);
        this.typeCombo.setEnabled(false);
    }

    public void fixDialect(int n) {
        this.typeCombo.select(n);
        this.typeCombo.setEnabled(false);
    }

    protected void okPressed() {
        int n = this.tabFolder.getSelectionIndex();
        if (n == 1) {
            this.updateTranslation();
        } else {
            this.updateConstraint();
        }
        super.okPressed();
    }

    private void updateTranslation() {
        this.success = true;
        this.constraint = new ConstraintImpl();
        this.constraint.setConstraint(null);
        this.constraint.setConstraint(this.getConstraintText());
        this.constraint.setName(this.nameText.getText());
        try {
            this.constraint.setPriority(Integer.parseInt(this.priorityText.getText()));
        }
        catch (NumberFormatException numberFormatException) {
            this.constraint.setPriority(1);
        }
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void updateConstraint() {
        this.constraint = new ConstraintImpl();
        if (!this.alwaysTrue.getSelection()) {
            this.constraint.setConstraint(this.getConstraintText());
        } else if (this.typeCombo.getSelectionIndex() == 0) {
            this.constraint.setConstraint("eval(true)");
        } else {
            this.constraint.setConstraint("return true;");
        }
        this.constraint.setName(this.nameText.getText());
        try {
            this.constraint.setPriority(Integer.parseInt(this.priorityText.getText()));
        }
        catch (NumberFormatException numberFormatException) {
            this.constraint.setPriority(1);
        }
        this.constraint.setType(this.typeCombo.getItem(this.typeCombo.getSelectionIndex()));
        this.constraint.setDialect(this.dialectCombo.getItem(this.dialectCombo.getSelectionIndex()));
    }

    public Constraint getConstraint() {
        return this.constraint;
    }

    public void setConstraint(Constraint constraint) {
        this.constraint = constraint;
        if (constraint != null) {
            if ("eval(true)".equals(constraint.getConstraint()) || "return true;".equals(constraint.getConstraint())) {
                this.alwaysTrue.setSelection(true);
            } else {
                this.setConstraintText(constraint.getConstraint() == null ? "" : constraint.getConstraint());
            }
            this.tabFolder.setVisible(!this.alwaysTrue.getSelection());
            this.nameText.setText(constraint.getName() == null ? "" : constraint.getName());
            this.priorityText.setText(String.valueOf(constraint.getPriority()));
            int n = 0;
            String string = constraint.getType();
            int n2 = ArrayUtils.indexOf((Object[])TYPES, (Object)string);
            if (n2 >= 0) {
                n = n2;
            }
            this.typeCombo.select(n);
            n = 0;
            String string2 = constraint.getDialect();
            n2 = ArrayUtils.indexOf((Object[])DIALECTS, (Object)string2);
            if (n2 >= 0) {
                n = n2;
            }
            this.dialectCombo.select(n);
            this.completionProcessor.setType(this.typeCombo.getText());
            this.setConstraintText(constraint.getConstraint());
        } else {
            this.priorityText.setText("1");
            this.nameText.setText("constraint");
        }
    }
}

