/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.flow.ruleflow.view.property.constraint;

import java.util.List;
import java.util.Map;
import org.drools.eclipse.editors.DRLSourceViewerConfig;
import org.drools.eclipse.editors.scanners.DRLPartionScanner;
import org.drools.eclipse.flow.common.view.property.EditBeanDialog;
import org.drools.eclipse.flow.ruleflow.view.property.constraint.ConstraintCompletionProcessor;
import org.drools.eclipse.flow.ruleflow.view.property.constraint.RuleFlowGlobalsDialog;
import org.drools.eclipse.flow.ruleflow.view.property.constraint.RuleFlowImportsDialog;
import org.drools.workflow.core.WorkflowProcess;
import org.drools.workflow.core.node.MilestoneNode;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MilestoneConstraintDialog
extends EditBeanDialog<String> {
    private WorkflowProcess process;
    private TabFolder tabFolder;
    private SourceViewer constraintViewer;
    private ConstraintCompletionProcessor completionProcessor;

    public MilestoneConstraintDialog(Shell shell, WorkflowProcess workflowProcess, MilestoneNode milestoneNode) {
        super(shell, "Constraint editor");
        this.process = workflowProcess;
        this.setValue(milestoneNode.getConstraint());
    }

    @Override
    protected String updateValue(String string) {
        if (this.tabFolder.getSelectionIndex() == 0) {
            return this.getConstraintText();
        }
        return null;
    }

    @Override
    protected Point getInitialSize() {
        return new Point(600, 450);
    }

    private Control createTextualEditor(Composite composite) {
        this.constraintViewer = new SourceViewer(composite, null, 2048);
        this.constraintViewer.configure((SourceViewerConfiguration)new DRLSourceViewerConfig(null){

            public IReconciler getReconciler(ISourceViewer iSourceViewer) {
                return null;
            }

            public IContentAssistant getContentAssistant(ISourceViewer iSourceViewer) {
                ContentAssistant contentAssistant = new ContentAssistant();
                MilestoneConstraintDialog.this.completionProcessor = new ConstraintCompletionProcessor(MilestoneConstraintDialog.this.process);
                contentAssistant.setContentAssistProcessor((IContentAssistProcessor)MilestoneConstraintDialog.this.completionProcessor, "__dftl_partition_content_type");
                contentAssistant.setProposalPopupOrientation(10);
                return contentAssistant;
            }
        });
        String string = (String)this.getValue();
        if (string == null) {
            string = "";
        }
        Document document = new Document(string);
        this.constraintViewer.setDocument((IDocument)document);
        FastPartitioner fastPartitioner = new FastPartitioner((IPartitionTokenScanner)new DRLPartionScanner(), DRLPartionScanner.LEGAL_CONTENT_TYPES);
        fastPartitioner.connect((IDocument)document);
        document.setDocumentPartitioner((IDocumentPartitioner)fastPartitioner);
        this.constraintViewer.getControl().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.character == ' ' && keyEvent.stateMask == 262144) {
                    MilestoneConstraintDialog.this.constraintViewer.doOperation(13);
                }
            }

            public void keyReleased(KeyEvent keyEvent) {
            }
        });
        return this.constraintViewer.getControl();
    }

    private String getConstraintText() {
        return this.constraintViewer.getDocument().get();
    }

    public Control createDialogArea(Composite composite) {
        GridLayout gridLayout = new GridLayout();
        composite.setLayout((Layout)gridLayout);
        gridLayout.numColumns = 2;
        Composite composite2 = new Composite(composite, 0);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.grabExcessHorizontalSpace = true;
        composite2.setLayoutData((Object)gridData);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        composite2.setLayout((Layout)gridLayout);
        Button button = new Button(composite2, 8);
        button.setText("Imports ...");
        button.setFont(JFaceResources.getDialogFont());
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                MilestoneConstraintDialog.this.importButtonPressed();
            }
        });
        gridData = new GridData();
        button.setLayoutData((Object)gridData);
        Button button2 = new Button(composite2, 8);
        button2.setText("Globals ...");
        button2.setFont(JFaceResources.getDialogFont());
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                MilestoneConstraintDialog.this.globalButtonPressed();
            }
        });
        gridData = new GridData();
        button2.setLayoutData((Object)gridData);
        this.tabFolder = new TabFolder(composite, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.verticalAlignment = 4;
        gridData.horizontalAlignment = 4;
        this.tabFolder.setLayoutData((Object)gridData);
        TabItem tabItem = new TabItem(this.tabFolder, 0);
        tabItem.setText("Textual Editor");
        tabItem.setControl(this.createTextualEditor((Composite)this.tabFolder));
        return this.tabFolder;
    }

    private void importButtonPressed() {
        Runnable runnable = new Runnable(){

            public void run() {
                RuleFlowImportsDialog ruleFlowImportsDialog = new RuleFlowImportsDialog(MilestoneConstraintDialog.this.getShell(), MilestoneConstraintDialog.this.process);
                ruleFlowImportsDialog.create();
                int n = ruleFlowImportsDialog.open();
                if (n != 1) {
                    List<String> list = ruleFlowImportsDialog.getImports();
                    MilestoneConstraintDialog.this.process.setImports(list);
                    List<String> list2 = ruleFlowImportsDialog.getFunctionImports();
                    MilestoneConstraintDialog.this.process.setFunctionImports(list2);
                    MilestoneConstraintDialog.this.completionProcessor.reset();
                }
            }
        };
        runnable.run();
    }

    private void globalButtonPressed() {
        Runnable runnable = new Runnable(){

            public void run() {
                RuleFlowGlobalsDialog ruleFlowGlobalsDialog = new RuleFlowGlobalsDialog(MilestoneConstraintDialog.this.getShell(), MilestoneConstraintDialog.this.process);
                ruleFlowGlobalsDialog.create();
                int n = ruleFlowGlobalsDialog.open();
                if (n != 1) {
                    Map<String, String> map = ruleFlowGlobalsDialog.getGlobals();
                    MilestoneConstraintDialog.this.process.setGlobals(map);
                    MilestoneConstraintDialog.this.completionProcessor.reset();
                }
            }
        };
        runnable.run();
    }
}

