/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.flow.ruleflow.editor.editpart;

import org.drools.eclipse.DroolsEclipsePlugin;
import org.drools.eclipse.flow.common.editor.core.ModelEvent;
import org.drools.eclipse.flow.common.editor.editpart.ElementEditPart;
import org.drools.eclipse.flow.common.editor.editpart.figure.AbstractElementFigure;
import org.drools.eclipse.flow.ruleflow.core.SplitWrapper;
import org.drools.eclipse.flow.ruleflow.skin.SkinManager;
import org.drools.eclipse.flow.ruleflow.skin.SkinProvider;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.Ellipse;
import org.eclipse.draw2d.EllipseAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.Request;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;

public class SplitEditPart
extends ElementEditPart {
    private String SKIN = DroolsEclipsePlugin.getDefault().getPreferenceStore().getString("Drools.Flow.Skin");

    protected IFigure createFigure() {
        SkinProvider skinProvider = SkinManager.getInstance().getSkinProvider(this.SKIN);
        SplitFigureInterface splitFigureInterface = skinProvider.createSplitFigure();
        Rectangle rectangle = this.getElementWrapper().getConstraint();
        if (rectangle.width == -1) {
            rectangle.width = splitFigureInterface.getSize().width;
        }
        if (rectangle.height == -1) {
            rectangle.height = splitFigureInterface.getSize().height;
        }
        this.getElementWrapper().setConstraint(rectangle);
        return splitFigureInterface;
    }

    public void modelChanged(ModelEvent modelEvent) {
        if (modelEvent.getChange() == 5) {
            this.refreshVisuals();
        } else {
            super.modelChanged(modelEvent);
        }
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        int n = ((SplitWrapper)this.getModel()).getSplit().getType();
        ((SplitFigureInterface)this.getFigure()).setType(n);
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connectionEditPart) {
        return new EllipseAnchor(this.getFigure());
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connectionEditPart) {
        return new EllipseAnchor(this.getFigure());
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        return new EllipseAnchor(this.getFigure());
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        return new EllipseAnchor(this.getFigure());
    }

    public static class SplitFigure
    extends AbstractElementFigure
    implements SplitFigureInterface {
        private static final Color color = new Color((Device)Display.getCurrent(), 70, 130, 180);
        private Ellipse ellipse;

        protected void customizeFigure() {
            this.ellipse = new Ellipse();
            this.add((IFigure)this.ellipse, 0);
            this.ellipse.setBackgroundColor(color);
            this.ellipse.setBounds(this.getBounds());
        }

        public void setBounds(Rectangle rectangle) {
            super.setBounds(rectangle);
            this.ellipse.setBounds(rectangle);
        }

        public void setSelected(boolean bl) {
            super.setSelected(bl);
            this.ellipse.setLineWidth(bl ? 3 : 1);
            this.repaint();
        }

        public void setType(int n) {
        }
    }

    public static interface SplitFigureInterface
    extends IFigure {
        public void setType(int var1);
    }
}

