/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.flow.ruleflow.core;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.drools.eclipse.flow.common.editor.core.ElementConnection;
import org.drools.eclipse.flow.common.editor.core.ElementWrapper;
import org.drools.eclipse.flow.ruleflow.core.StateBasedNodeWrapper;
import org.drools.eclipse.flow.ruleflow.view.property.workitem.WorkItemParameterMappingPropertyDescriptor;
import org.drools.eclipse.flow.ruleflow.view.property.workitem.WorkItemResultMappingPropertyDescriptor;
import org.drools.process.core.ParameterDefinition;
import org.drools.process.core.Work;
import org.drools.process.core.WorkDefinition;
import org.drools.process.core.datatype.DataType;
import org.drools.process.core.impl.WorkImpl;
import org.drools.workflow.core.Node;
import org.drools.workflow.core.node.WorkItemNode;
import org.eclipse.ui.views.properties.ComboBoxPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

public class WorkItemWrapper
extends StateBasedNodeWrapper {
    public static final String WAIT_FOR_COMPLETION = "WaitForCompletion";
    public static final String RESULT_MAPPING = "ResultMapping";
    public static final String PARAMETER_MAPPING = "ParameterMapping";
    private static final long serialVersionUID = 510L;
    private WorkDefinition workDefinition;

    public WorkItemWrapper() {
        this.setNode((Node)new WorkItemNode());
    }

    public WorkItemNode getWorkItemNode() {
        return (WorkItemNode)this.getNode();
    }

    public void setNode(Node node) {
        super.setNode(node);
        if (this.workDefinition != null) {
            Work work = this.getWorkItemNode().getWork();
            if (work == null) {
                work = new WorkImpl();
                work.setName(this.workDefinition.getName());
                this.getWorkItemNode().setWork(work);
            }
            work.setParameterDefinitions(this.workDefinition.getParameters());
        }
    }

    public void setWorkDefinition(WorkDefinition workDefinition) {
        this.workDefinition = workDefinition;
        Work work = this.getWorkItemNode().getWork();
        if (work == null) {
            work = new WorkImpl();
            work.setName(workDefinition.getName());
            this.getWorkItemNode().setWork(work);
        }
        work.setParameterDefinitions(workDefinition.getParameters());
    }

    public WorkDefinition getWorkDefinition() {
        return this.workDefinition;
    }

    private boolean workParameterExists(String string) {
        if (this.workDefinition != null) {
            return this.workDefinition.getParameter(string) != null;
        }
        return false;
    }

    protected void initDescriptors() {
        super.initDescriptors();
        Set set = this.workDefinition.getParameters();
        IPropertyDescriptor[] iPropertyDescriptorArray = this.descriptors;
        this.descriptors = new IPropertyDescriptor[iPropertyDescriptorArray.length + set.size() + 5];
        System.arraycopy(iPropertyDescriptorArray, 0, this.descriptors, 0, iPropertyDescriptorArray.length);
        int n = 0;
        for (ParameterDefinition parameterDefinition : set) {
            this.descriptors[iPropertyDescriptorArray.length + n++] = new TextPropertyDescriptor((Object)parameterDefinition.getName(), parameterDefinition.getName());
        }
        this.descriptors[this.descriptors.length - 5] = this.getOnEntryPropertyDescriptor();
        this.descriptors[this.descriptors.length - 4] = this.getOnExitPropertyDescriptor();
        this.descriptors[this.descriptors.length - 3] = new ComboBoxPropertyDescriptor((Object)WAIT_FOR_COMPLETION, "Wait for completion", new String[]{"true", "false"});
        this.descriptors[this.descriptors.length - 2] = new WorkItemParameterMappingPropertyDescriptor(PARAMETER_MAPPING, "Parameter Mapping", this.getWorkItemNode());
        this.descriptors[this.descriptors.length - 1] = new WorkItemResultMappingPropertyDescriptor(RESULT_MAPPING, "Result Mapping", this.getWorkItemNode());
    }

    public boolean acceptsIncomingConnection(ElementConnection elementConnection, ElementWrapper elementWrapper) {
        return super.acceptsIncomingConnection(elementConnection, elementWrapper) && this.getIncomingConnections().isEmpty();
    }

    public boolean acceptsOutgoingConnection(ElementConnection elementConnection, ElementWrapper elementWrapper) {
        return super.acceptsOutgoingConnection(elementConnection, elementWrapper) && this.getOutgoingConnections().isEmpty();
    }

    public Object getPropertyValue(Object object) {
        String string;
        if (WAIT_FOR_COMPLETION.equals(object)) {
            return this.getWorkItemNode().isWaitForCompletion() ? new Integer(0) : new Integer(1);
        }
        if (PARAMETER_MAPPING.equals(object)) {
            return this.getWorkItemNode().getInMappings();
        }
        if (RESULT_MAPPING.equals(object)) {
            return this.getWorkItemNode().getOutMappings();
        }
        if (object instanceof String && this.workParameterExists(string = (String)object)) {
            DataType dataType = this.getWorkItemNode().getWork().getParameterDefinition(string).getType();
            Object object2 = this.getWorkItemNode().getWork().getParameter(string);
            if (object2 == null) {
                return "";
            }
            return dataType.writeValue(object2);
        }
        return super.getPropertyValue(object);
    }

    public void resetPropertyValue(Object object) {
        if (WAIT_FOR_COMPLETION.equals(object)) {
            this.getWorkItemNode().setWaitForCompletion(true);
        } else if (PARAMETER_MAPPING.equals(object)) {
            this.getWorkItemNode().setInMappings(new HashMap());
        } else if (RESULT_MAPPING.equals(object)) {
            this.getWorkItemNode().setOutMappings(new HashMap());
        } else if (object instanceof String && this.workParameterExists((String)object)) {
            this.getWorkItemNode().getWork().setParameter((String)object, null);
        } else {
            super.resetPropertyValue(object);
        }
    }

    public void setPropertyValue(Object object, Object object2) {
        if (WAIT_FOR_COMPLETION.equals(object)) {
            this.getWorkItemNode().setWaitForCompletion((Integer)object2 == 0);
        } else if (PARAMETER_MAPPING.equals(object)) {
            this.getWorkItemNode().setInMappings((Map)object2);
        } else if (RESULT_MAPPING.equals(object)) {
            this.getWorkItemNode().setOutMappings((Map)object2);
        } else if (object instanceof String && this.workParameterExists((String)object)) {
            DataType dataType = this.getWorkItemNode().getWork().getParameterDefinition((String)object).getType();
            this.getWorkItemNode().getWork().setParameter((String)object, dataType.readValue((String)object2));
        } else {
            super.setPropertyValue(object, object2);
        }
    }
}

