/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.flow.ruleflow.core;

import java.util.HashMap;
import java.util.Map;
import org.drools.definition.process.Connection;
import org.drools.eclipse.flow.common.editor.core.ElementConnection;
import org.drools.eclipse.flow.common.editor.core.ElementWrapper;
import org.drools.eclipse.flow.ruleflow.core.ConnectionWrapper;
import org.drools.eclipse.flow.ruleflow.core.StateBasedNodeWrapper;
import org.drools.eclipse.flow.ruleflow.view.property.constraint.StateConstraintsPropertyDescriptor;
import org.drools.workflow.core.Constraint;
import org.drools.workflow.core.Node;
import org.drools.workflow.core.WorkflowProcess;
import org.drools.workflow.core.impl.ConnectionRef;
import org.drools.workflow.core.node.StateNode;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class StateNodeWrapper
extends StateBasedNodeWrapper {
    public static final String CONSTRAINTS = "constraints";
    private static final long serialVersionUID = 510L;

    public StateNodeWrapper() {
        this.setNode((Node)new StateNode());
        this.getStateNode().setName("State");
    }

    protected void initDescriptors() {
        super.initDescriptors();
        IPropertyDescriptor[] iPropertyDescriptorArray = this.descriptors;
        this.descriptors = new IPropertyDescriptor[iPropertyDescriptorArray.length + 3];
        System.arraycopy(iPropertyDescriptorArray, 0, this.descriptors, 0, iPropertyDescriptorArray.length);
        this.descriptors[this.descriptors.length - 3] = this.getOnEntryPropertyDescriptor();
        this.descriptors[this.descriptors.length - 2] = this.getOnExitPropertyDescriptor();
        this.descriptors[this.descriptors.length - 1] = new StateConstraintsPropertyDescriptor(CONSTRAINTS, "Constraints", this.getStateNode(), (WorkflowProcess)this.getParent().getProcessWrapper().getProcess());
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        if (this.descriptors == null) {
            this.initDescriptors();
        }
        return this.descriptors;
    }

    public void setNode(Node node) {
        super.setNode(node);
        for (Connection connection : this.getStateNode().getOutgoingConnections("DROOLS_DEFAULT")) {
            String string = null;
            Constraint constraint = this.getStateNode().getConstraint(connection);
            if (constraint != null) {
                string = constraint.getName();
            }
            ((org.drools.workflow.core.Connection)connection).setMetaData("label", (Object)string);
        }
    }

    public StateNode getStateNode() {
        return (StateNode)this.getNode();
    }

    private void updateConnectionLabels() {
        for (ElementConnection elementConnection : this.getOutgoingConnections()) {
            this.updateConnectionLabel(elementConnection);
        }
    }

    private void updateConnectionLabel(ElementConnection elementConnection) {
        ConnectionWrapper connectionWrapper = (ConnectionWrapper)elementConnection;
        String string = null;
        Constraint constraint = this.getStateNode().getConstraint((Connection)connectionWrapper.getConnection());
        if (constraint != null) {
            string = constraint.getName();
        }
        connectionWrapper.getConnection().setMetaData("label", (Object)string);
        connectionWrapper.notifyListeners(2);
    }

    public boolean acceptsIncomingConnection(ElementConnection elementConnection, ElementWrapper elementWrapper) {
        return super.acceptsIncomingConnection(elementConnection, elementWrapper) && this.getIncomingConnections().isEmpty();
    }

    public Object getPropertyValue(Object object) {
        if (CONSTRAINTS.equals(object)) {
            return new MyHashMap(this.getStateNode().getConstraints());
        }
        return super.getPropertyValue(object);
    }

    public void resetPropertyValue(Object object) {
        if (CONSTRAINTS.equals(object)) {
            for (Connection connection : this.getStateNode().getOutgoingConnections("DROOLS_DEFAULT")) {
                this.getStateNode().setConstraint(connection, null);
            }
            this.updateConnectionLabels();
        } else {
            super.resetPropertyValue(object);
        }
    }

    public void setPropertyValue(Object object, Object object2) {
        if (CONSTRAINTS.equals(object)) {
            for (Map.Entry entry : ((Map)object2).entrySet()) {
                ConnectionRef connectionRef = (ConnectionRef)entry.getKey();
                Connection connection = null;
                for (Connection connection2 : this.getStateNode().getOutgoingConnections("DROOLS_DEFAULT")) {
                    if (!connection2.getToType().equals(connectionRef.getToType()) || connection2.getTo().getId() != connectionRef.getNodeId()) continue;
                    connection = connection2;
                }
                if (connection == null) {
                    throw new IllegalArgumentException("Could not find outgoing connection");
                }
                this.getStateNode().setConstraint(connection, (Constraint)entry.getValue());
            }
            this.updateConnectionLabels();
        } else {
            super.setPropertyValue(object, object2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class MyHashMap<K, V>
    extends HashMap<K, V> {
        private static final long serialVersionUID = 510L;

        public MyHashMap() {
        }

        public MyHashMap(Map<K, V> map) {
            super(map);
        }

        @Override
        public String toString() {
            return "";
        }
    }
}

