/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.flow.ruleflow.core;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.HashMap;
import java.util.Map;
import org.drools.definition.process.Connection;
import org.drools.eclipse.flow.common.editor.core.ElementConnection;
import org.drools.eclipse.flow.common.editor.core.ElementWrapper;
import org.drools.eclipse.flow.ruleflow.core.AbstractNodeWrapper;
import org.drools.eclipse.flow.ruleflow.core.ConnectionWrapper;
import org.drools.eclipse.flow.ruleflow.view.property.constraint.ConstraintsPropertyDescriptor;
import org.drools.workflow.core.Constraint;
import org.drools.workflow.core.Node;
import org.drools.workflow.core.WorkflowProcess;
import org.drools.workflow.core.impl.ConnectionRef;
import org.drools.workflow.core.node.Split;
import org.eclipse.ui.views.properties.ComboBoxPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class SplitWrapper
extends AbstractNodeWrapper {
    public static final int CHANGE_TYPE = 5;
    public static final String TYPE = "type";
    public static final String CONSTRAINTS = "constraints";
    private static final long serialVersionUID = 510L;
    private transient IPropertyDescriptor[] descriptors;

    public SplitWrapper() {
        this.setNode((Node)new Split());
        this.getSplit().setName("Split");
        this.setDescriptors();
    }

    public void setNode(Node node) {
        super.setNode(node);
        for (Connection connection : this.getSplit().getDefaultOutgoingConnections()) {
            String string = null;
            Constraint constraint = this.getSplit().internalGetConstraint(new ConnectionRef(connection.getTo().getId(), connection.getToType()));
            if (constraint != null) {
                string = constraint.getName();
            }
            ((org.drools.workflow.core.Connection)connection).setMetaData("label", (Object)string);
        }
    }

    private void updateConnectionLabels() {
        for (ElementConnection elementConnection : this.getOutgoingConnections()) {
            this.updateConnectionLabel(elementConnection);
        }
    }

    private void updateConnectionLabel(ElementConnection elementConnection) {
        ConnectionWrapper connectionWrapper = (ConnectionWrapper)elementConnection;
        String string = null;
        Constraint constraint = this.getSplit().internalGetConstraint(new ConnectionRef(connectionWrapper.getConnection().getTo().getId(), connectionWrapper.getConnection().getToType()));
        if (constraint != null) {
            string = constraint.getName();
        }
        connectionWrapper.getConnection().setMetaData("label", (Object)string);
        connectionWrapper.notifyListeners(2);
    }

    private void setDescriptors() {
        this.descriptors = new IPropertyDescriptor[AbstractNodeWrapper.DESCRIPTORS.length + 1];
        System.arraycopy(AbstractNodeWrapper.DESCRIPTORS, 0, this.descriptors, 0, AbstractNodeWrapper.DESCRIPTORS.length);
        this.descriptors[this.descriptors.length - 1] = new ComboBoxPropertyDescriptor((Object)TYPE, "Type", new String[]{"", "AND", "XOR", "OR"});
    }

    public Split getSplit() {
        return (Split)this.getNode();
    }

    public boolean acceptsIncomingConnection(ElementConnection elementConnection, ElementWrapper elementWrapper) {
        return super.acceptsIncomingConnection(elementConnection, elementWrapper) && this.getIncomingConnections().isEmpty();
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        if (this.getParent() != null && (this.getSplit().getType() == 2 || this.getSplit().getType() == 3)) {
            IPropertyDescriptor[] iPropertyDescriptorArray = new IPropertyDescriptor[this.descriptors.length + 1];
            System.arraycopy(this.descriptors, 0, iPropertyDescriptorArray, 0, this.descriptors.length);
            iPropertyDescriptorArray[this.descriptors.length] = new ConstraintsPropertyDescriptor(CONSTRAINTS, "Constraints", this.getSplit(), (WorkflowProcess)this.getParent().getProcessWrapper().getProcess());
            return iPropertyDescriptorArray;
        }
        return this.descriptors;
    }

    public Object getPropertyValue(Object object) {
        if (TYPE.equals(object)) {
            return new Integer(this.getSplit().getType());
        }
        if (CONSTRAINTS.equals(object)) {
            return this.getSplit().getType() == 2 || this.getSplit().getType() == 3 ? new MyHashMap(this.getSplit().getConstraints()) : new MyHashMap();
        }
        return super.getPropertyValue(object);
    }

    public void resetPropertyValue(Object object) {
        if (TYPE.equals(object)) {
            this.getSplit().setType(0);
            this.notifyListeners(5);
            this.updateConnectionLabels();
        } else if (CONSTRAINTS.equals(object)) {
            for (Connection connection : this.getSplit().getDefaultOutgoingConnections()) {
                this.getSplit().setConstraint(connection, null);
            }
            this.updateConnectionLabels();
        } else {
            super.resetPropertyValue(object);
        }
    }

    public void setPropertyValue(Object object, Object object2) {
        if (TYPE.equals(object)) {
            this.getSplit().setType(((Integer)object2).intValue());
            this.notifyListeners(5);
            this.updateConnectionLabels();
        } else if (CONSTRAINTS.equals(object)) {
            for (Map.Entry entry : ((Map)object2).entrySet()) {
                ConnectionRef connectionRef = (ConnectionRef)entry.getKey();
                Connection connection = null;
                for (Connection connection2 : this.getSplit().getDefaultOutgoingConnections()) {
                    if (!connection2.getToType().equals(connectionRef.getToType()) || connection2.getTo().getId() != connectionRef.getNodeId()) continue;
                    connection = connection2;
                }
                if (connection == null) {
                    throw new IllegalArgumentException("Could not find outgoing connection");
                }
                this.getSplit().setConstraint(connection, (Constraint)entry.getValue());
            }
            this.updateConnectionLabels();
        } else {
            super.setPropertyValue(object, object2);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.setDescriptors();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class MyHashMap<K, V>
    extends HashMap<K, V> {
        private static final long serialVersionUID = 510L;

        public MyHashMap() {
        }

        public MyHashMap(Map<K, V> map) {
            super(map);
        }

        @Override
        public String toString() {
            return "";
        }
    }
}

