/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.flow.ruleflow.core;

import java.util.ArrayList;
import org.drools.eclipse.flow.common.editor.core.ElementConnection;
import org.drools.eclipse.flow.common.editor.core.ElementWrapper;
import org.drools.eclipse.flow.ruleflow.core.AbstractNodeWrapper;
import org.drools.process.core.event.EventTypeFilter;
import org.drools.workflow.core.Node;
import org.drools.workflow.core.node.EventNode;
import org.eclipse.ui.views.properties.ComboBoxPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

public class EventNodeWrapper
extends AbstractNodeWrapper {
    private static final long serialVersionUID = 510L;
    private static IPropertyDescriptor[] descriptors = new IPropertyDescriptor[AbstractNodeWrapper.DESCRIPTORS.length + 3];
    public static final String VARIABLE_NAME = "variableName";
    public static final String EVENT_TYPE = "eventType";
    public static final String SCOPE = "scope";

    static {
        System.arraycopy(AbstractNodeWrapper.DESCRIPTORS, 0, descriptors, 0, AbstractNodeWrapper.DESCRIPTORS.length);
        EventNodeWrapper.descriptors[EventNodeWrapper.descriptors.length - 3] = new ComboBoxPropertyDescriptor((Object)SCOPE, "Scope", new String[]{"internal", "external"});
        EventNodeWrapper.descriptors[EventNodeWrapper.descriptors.length - 2] = new TextPropertyDescriptor((Object)VARIABLE_NAME, "VariableName");
        EventNodeWrapper.descriptors[EventNodeWrapper.descriptors.length - 1] = new TextPropertyDescriptor((Object)EVENT_TYPE, "EventType");
    }

    public EventNodeWrapper() {
        this.setNode((Node)new EventNode());
        this.setName("Event");
    }

    public EventNode getEventNode() {
        return (EventNode)this.getNode();
    }

    public boolean acceptsIncomingConnection(ElementConnection elementConnection, ElementWrapper elementWrapper) {
        return false;
    }

    public boolean acceptsOutgoingConnection(ElementConnection elementConnection, ElementWrapper elementWrapper) {
        return super.acceptsOutgoingConnection(elementConnection, elementWrapper) && this.getOutgoingConnections().isEmpty();
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        return descriptors;
    }

    public Object getPropertyValue(Object object) {
        if (VARIABLE_NAME.equals(object)) {
            String string = this.getEventNode().getVariableName();
            return string == null ? "" : string;
        }
        if (EVENT_TYPE.equals(object)) {
            if (this.getEventNode().getEventFilters().isEmpty()) {
                return "";
            }
            return ((EventTypeFilter)this.getEventNode().getEventFilters().get(0)).getType();
        }
        if (SCOPE.equals(object)) {
            return "external".equals(this.getEventNode().getScope()) ? 1 : 0;
        }
        return super.getPropertyValue(object);
    }

    public void resetPropertyValue(Object object) {
        if (VARIABLE_NAME.equals(object)) {
            this.getEventNode().setVariableName(null);
        } else if (EVENT_TYPE.equals(object)) {
            this.getEventNode().setEventFilters(new ArrayList());
        } else if (SCOPE.equals(object)) {
            this.getEventNode().setScope("internal");
        } else {
            super.resetPropertyValue(object);
        }
    }

    public void setPropertyValue(Object object, Object object2) {
        if (VARIABLE_NAME.equals(object)) {
            this.getEventNode().setVariableName((String)object2);
        } else if (EVENT_TYPE.equals(object)) {
            ArrayList<EventTypeFilter> arrayList = new ArrayList<EventTypeFilter>();
            EventTypeFilter eventTypeFilter = new EventTypeFilter();
            eventTypeFilter.setType((String)object2);
            arrayList.add(eventTypeFilter);
            this.getEventNode().setEventFilters(arrayList);
        } else if (SCOPE.equals(object)) {
            this.getEventNode().setScope((Integer)object2 == 1 ? "external" : "internal");
        } else {
            super.setPropertyValue(object, object2);
        }
    }
}

