/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.flow.ruleflow;

import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.ide.IDE;

public class NewRuleFlowFilePage
extends WizardNewFileCreationPage {
    private IWorkbench workbench;
    private String targetRuntime;

    public NewRuleFlowFilePage(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
        super("createRuleFlowPage", iStructuredSelection);
        this.setTitle("Create Flow File");
        this.setDescription("Create a new Flow file");
        this.workbench = iWorkbench;
    }

    public void createControl(Composite composite) {
        super.createControl(composite);
        this.setPageComplete(true);
    }

    public void setTargetRuntime(String string) {
        this.targetRuntime = string;
    }

    public boolean finish() {
        IFile iFile;
        String string = this.getFileName();
        if ("Drools 5.0.x".equals(this.targetRuntime)) {
            if (!string.endsWith(".rf")) {
                this.setFileName(String.valueOf(string) + ".rf");
            }
        } else if ("Drools 5.1.x".equals(this.targetRuntime) && !string.endsWith(".bpmn")) {
            this.setFileName(String.valueOf(string) + ".bpmn");
        }
        if ((iFile = this.createNewFile()) == null) {
            return false;
        }
        try {
            IWorkbenchWindow iWorkbenchWindow = this.workbench.getActiveWorkbenchWindow();
            IWorkbenchPage iWorkbenchPage = iWorkbenchWindow.getActivePage();
            if (iWorkbenchPage != null) {
                IDE.openEditor((IWorkbenchPage)iWorkbenchPage, (IFile)iFile, (boolean)true);
            }
        }
        catch (PartInitException partInitException) {
            partInitException.printStackTrace();
            return false;
        }
        return true;
    }

    protected InputStream getInitialContents() {
        if ("Drools 5.0.x".equals(this.targetRuntime)) {
            String string = "org/drools/eclipse/flow/ruleflow/SampleRuleFlow.rf.template";
            return ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(string);
        }
        if ("Drools 5.1.x".equals(this.targetRuntime)) {
            String string = "org/drools/eclipse/flow/bpmn2/Sample.bpmn.template";
            return ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(string);
        }
        throw new IllegalArgumentException("Unknown target runtime " + this.targetRuntime);
    }
}

