/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.flow.common.view.property;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.drools.eclipse.flow.common.view.property.EditBeanDialog;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EditListDialog<T>
extends EditBeanDialog<List<T>> {
    private Class<? extends EditBeanDialog<T>> editItemDialogClass;
    private List<T> newList;
    private ListViewer listViewer;
    private Button removeButton;
    private Button editButton;

    protected EditListDialog(Shell shell, String string, Class<? extends EditBeanDialog<T>> clazz) {
        super(shell, string);
        this.editItemDialogClass = clazz;
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        this.listViewer = new ListViewer(composite2, 4);
        this.listViewer.add(this.newList.toArray());
        this.listViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                EditListDialog.this.removeButton.setEnabled(!selectionChangedEvent.getSelection().isEmpty());
                EditListDialog.this.editButton.setEnabled(!selectionChangedEvent.getSelection().isEmpty());
            }
        });
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.verticalSpan = 3;
        this.listViewer.getList().setLayoutData((Object)gridData);
        Button button = new Button(composite2, 0);
        button.setText("Add");
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 1;
        button.setLayoutData((Object)gridData);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                EditListDialog.this.addItem();
            }
        });
        this.removeButton = new Button(composite2, 0);
        this.removeButton.setText("Remove");
        this.removeButton.setEnabled(false);
        gridData = new GridData();
        gridData.verticalAlignment = 1;
        this.removeButton.setLayoutData((Object)gridData);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                EditListDialog.this.removeItem();
            }
        });
        this.editButton = new Button(composite2, 0);
        this.editButton.setText("Edit");
        this.editButton.setEnabled(false);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 1;
        this.editButton.setLayoutData((Object)gridData);
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                EditListDialog.this.editItem();
            }
        });
        return composite2;
    }

    @Override
    public void setValue(List<T> list) {
        super.setValue(list);
        this.newList = list == null ? new ArrayList<T>() : new ArrayList<T>(list);
    }

    @Override
    protected List<T> updateValue(List<T> list) {
        return this.newList;
    }

    private void addItem() {
        EditBeanDialog<T> editBeanDialog = this.createEditItemDialog();
        editBeanDialog.setValue(this.createItem());
        int n = editBeanDialog.open();
        T t = editBeanDialog.getValue();
        if (n != 1) {
            this.newList.add(t);
            this.listViewer.add(t);
        }
    }

    protected abstract T createItem();

    private void editItem() {
        EditBeanDialog<T> editBeanDialog = this.createEditItemDialog();
        Iterator iterator = ((StructuredSelection)this.listViewer.getSelection()).iterator();
        if (iterator.hasNext()) {
            Object e = iterator.next();
            int n = this.newList.lastIndexOf(e);
            editBeanDialog.setValue(e);
            int n2 = editBeanDialog.open();
            if (n2 != 1) {
                T t = editBeanDialog.getValue();
                this.newList.set(n, t);
                this.listViewer.remove(e);
                this.listViewer.add(t);
            }
        }
    }

    private void removeItem() {
        Iterator iterator = ((StructuredSelection)this.listViewer.getSelection()).iterator();
        if (iterator.hasNext()) {
            Object e = iterator.next();
            this.newList.remove(e);
            this.listViewer.remove(e);
        }
    }

    protected EditBeanDialog<T> createEditItemDialog() {
        try {
            return this.editItemDialogClass.getConstructor(Shell.class).newInstance(this.getShell());
        }
        catch (InstantiationException instantiationException) {
            throw new RuntimeException(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new RuntimeException(invocationTargetException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new RuntimeException(noSuchMethodException);
        }
    }
}

