/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.flow.common.view.datatype.editor.impl;

import java.util.ArrayList;
import java.util.List;
import org.drools.eclipse.flow.common.view.datatype.editor.DataTypeEditor;
import org.drools.eclipse.flow.common.view.datatype.editor.Editor;
import org.drools.process.core.datatype.DataType;
import org.drools.process.core.datatype.impl.type.ObjectDataType;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ObjectDataTypeEditor
extends Composite
implements Editor,
DataTypeEditor {
    private ObjectDataType dataType;
    private Object value;
    private Label label;
    private Text text;
    private List<DataTypeEditor.DataTypeListener> listeners = new ArrayList<DataTypeEditor.DataTypeListener>();

    public ObjectDataTypeEditor(Composite composite) {
        super(composite, 0);
        this.setLayout((Layout)new FillLayout());
        this.label = new Label((Composite)this, 0);
        this.label.setText("ClassName");
        this.text = new Text((Composite)this, 0);
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                ObjectDataTypeEditor.this.notifyListeners();
            }
        });
    }

    public DataType getDataType() {
        this.dataType.setClassName(this.text.getText());
        return this.dataType;
    }

    public void setDataType(DataType dataType) {
        this.dataType = (ObjectDataType)dataType;
        String string = this.dataType.getClassName();
        this.text.setText(string == null ? "" : string);
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object object) {
        this.value = object;
    }

    public void reset() {
        this.text.setText("");
    }

    public void addListener(DataTypeEditor.DataTypeListener dataTypeListener) {
        this.listeners.add(dataTypeListener);
    }

    public void removeListener(DataTypeEditor.DataTypeListener dataTypeListener) {
        this.listeners.remove(dataTypeListener);
    }

    private void notifyListeners() {
        for (DataTypeEditor.DataTypeListener dataTypeListener : this.listeners) {
            dataTypeListener.dataTypeChanged(this.getDataType());
        }
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.label.setBackground(color);
    }
}

