/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.flow.common.view.datatype.editor.impl;

import org.drools.eclipse.flow.common.view.datatype.editor.Editor;
import org.drools.process.core.datatype.DataType;
import org.drools.process.core.datatype.impl.type.FloatDataType;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class FloatEditor
extends Composite
implements Editor {
    private Text text;

    public FloatEditor(Composite composite) {
        super(composite, 0);
        this.setLayout((Layout)new FillLayout());
        this.text = new Text((Composite)this, 0);
    }

    public void setDataType(DataType dataType) {
        if (!(dataType instanceof FloatDataType)) {
            throw new IllegalArgumentException("Illegal data type " + dataType);
        }
    }

    public Object getValue() throws IllegalArgumentException {
        String string = this.text.getText();
        if ("".equals(string)) {
            return null;
        }
        try {
            return new Float(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("The value " + string + " is not a valid float.");
        }
    }

    public void setValue(Object object) {
        if (object == null) {
            this.text.setText("");
        } else if (object instanceof Float) {
            this.text.setText(((Float)object).toString());
        } else {
            throw new IllegalArgumentException("Value must be a float: " + object);
        }
    }

    public void reset() {
        this.text.setText("");
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.text.setEnabled(bl);
    }
}

