/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.flow.common.view.datatype.editor.impl;

import java.lang.reflect.InvocationTargetException;
import org.drools.eclipse.DroolsEclipsePlugin;
import org.drools.eclipse.flow.common.datatype.DataTypeRegistry;
import org.drools.eclipse.flow.common.view.datatype.editor.Editor;
import org.drools.eclipse.flow.common.view.datatype.editor.impl.EmptyEditor;
import org.drools.process.core.datatype.DataType;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class EditorComposite
extends Composite {
    private DataTypeRegistry registry;
    private Editor editor;

    public EditorComposite(Composite composite, int n, DataTypeRegistry dataTypeRegistry) {
        super(composite, n);
        this.registry = dataTypeRegistry;
        this.setLayout((Layout)new FillLayout());
        this.editor = new EmptyEditor(this);
    }

    public void setDataType(DataType dataType) {
        ((Composite)this.editor).dispose();
        if (dataType == null) {
            this.editor = new EmptyEditor(this);
        } else {
            Class clazz = null;
            try {
                clazz = this.registry.getDataTypeInfo(dataType.getClass()).getValueEditorClass();
                this.editor = (Editor)clazz.getConstructor(Composite.class).newInstance(new Object[]{this});
            }
            catch (IllegalArgumentException illegalArgumentException) {
                DroolsEclipsePlugin.log(illegalArgumentException);
                this.editor = new EmptyEditor(this);
            }
            catch (InstantiationException instantiationException) {
                DroolsEclipsePlugin.log(instantiationException);
                this.editor = new EmptyEditor(this);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                DroolsEclipsePlugin.log(noSuchMethodException);
                this.editor = new EmptyEditor(this);
            }
            catch (InvocationTargetException invocationTargetException) {
                DroolsEclipsePlugin.log(invocationTargetException);
                this.editor = new EmptyEditor(this);
            }
            catch (IllegalAccessException illegalAccessException) {
                DroolsEclipsePlugin.log(illegalAccessException);
                this.editor = new EmptyEditor(this);
            }
            this.editor.setDataType(dataType);
            this.layout();
        }
    }

    public void setValue(Object object) {
        this.editor.setValue(object);
    }

    public Object getValue() {
        return this.editor.getValue();
    }

    public void reset() {
        this.editor.reset();
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        ((Composite)this.editor).setEnabled(bl);
    }
}

