/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.flow.common.view.datatype.editor.impl;

import org.drools.eclipse.DroolsEclipsePlugin;
import org.drools.eclipse.flow.common.datatype.DataTypeRegistry;
import org.drools.process.core.datatype.DataType;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class DataTypeCombo
extends Composite {
    private DataTypeRegistry registry;
    private ComboViewer dataTypeCombo;

    public DataTypeCombo(Composite composite, int n, DataTypeRegistry dataTypeRegistry) {
        super(composite, n);
        this.registry = dataTypeRegistry;
        this.setLayout((Layout)new FillLayout());
        this.dataTypeCombo = new ComboViewer((Composite)this, 8);
        this.dataTypeCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object object) {
                return ((DataTypeRegistry.IDataTypeInfo)object).getName();
            }
        });
        this.dataTypeCombo.add((Object[])dataTypeRegistry.getDataTypes().toArray(new DataTypeRegistry.IDataTypeInfo[0]));
    }

    private DataTypeRegistry.IDataTypeInfo getSelectedTypeInfo() {
        ISelection iSelection = this.dataTypeCombo.getSelection();
        if (!iSelection.isEmpty()) {
            return (DataTypeRegistry.IDataTypeInfo)((StructuredSelection)iSelection).getFirstElement();
        }
        return null;
    }

    public void setDataType(DataType dataType) {
        if (dataType == null) {
            this.dataTypeCombo.setSelection(null);
        } else {
            try {
                this.dataTypeCombo.setSelection((ISelection)new StructuredSelection((Object)this.registry.getDataTypeInfo(dataType.getClass())));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                DroolsEclipsePlugin.log(illegalArgumentException);
            }
        }
    }

    public DataType getDataType() {
        DataTypeRegistry.IDataTypeInfo iDataTypeInfo = this.getSelectedTypeInfo();
        return iDataTypeInfo == null ? null : iDataTypeInfo.getDataTypeFactory().createDataType();
    }

    public void reset() {
        this.dataTypeCombo.setSelection(null);
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.dataTypeCombo.getCombo().setEnabled(bl);
    }

    public void addSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.dataTypeCombo.addSelectionChangedListener(iSelectionChangedListener);
    }
}

